/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;
import org.primefaces.context.PrimePartialResponseWriter;
import org.primefaces.util.ComponentUtils;
import org.primefaces.visit.ResetInputVisitCallback;

public class PrimePartialViewContext
extends PartialViewContextWrapper {
    private static final Logger LOG = Logger.getLogger(PrimePartialViewContext.class.getName());
    private PartialViewContext wrapped;
    private PartialResponseWriter writer = null;

    public PrimePartialViewContext(PartialViewContext wrapped) {
        this.wrapped = wrapped;
    }

    public PartialViewContext getWrapped() {
        return this.wrapped;
    }

    public void processPartial(PhaseId phaseId) {
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.resetValues(context);
        }
        this.getWrapped().processPartial(phaseId);
    }

    public void setPartialRequest(boolean value) {
        this.getWrapped().setPartialRequest(value);
    }

    public PartialResponseWriter getPartialResponseWriter() {
        if (this.writer == null) {
            PartialResponseWriter parentWriter = this.getWrapped().getPartialResponseWriter();
            this.writer = new PrimePartialResponseWriter(parentWriter);
        }
        return this.writer;
    }

    public boolean isAjaxRequest() {
        return this.getWrapped().isAjaxRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("javax.faces.partial.ajax");
    }

    public boolean isPartialRequest() {
        return this.getWrapped().isPartialRequest() || FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().containsKey("javax.faces.partial.execute");
    }

    private void resetValues(FacesContext context) {
        boolean resetValues;
        Object resetValuesObject = context.getExternalContext().getRequestParameterMap().get("primefaces.resetvalues");
        boolean bl = resetValues = null != resetValuesObject && "true".equals(resetValuesObject);
        if (resetValues) {
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
            for (String renderId : context.getPartialViewContext().getRenderIds()) {
                UIComponent renderComponent = context.getViewRoot().findComponent(renderId);
                if (renderComponent == null) {
                    LOG.log(Level.WARNING, "Could not find component with ID: " + renderId + ". This may occur if you use h:form with prependId=false, as findComponent does not consider it.");
                    continue;
                }
                renderComponent.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
            }
        }
    }
}

