/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectbooleanbutton;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.selectbooleanbutton.SelectBooleanButton;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class SelectBooleanButtonRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        SelectBooleanButton button = (SelectBooleanButton)component;
        if (button.isDisabled()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)button);
        String clientId = button.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        if (submittedValue != null && submittedValue.equalsIgnoreCase("on")) {
            button.setSubmittedValue("true");
        } else {
            button.setSubmittedValue("false");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectBooleanButton button = (SelectBooleanButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SelectBooleanButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        boolean checked = Boolean.valueOf(ComponentUtils.getValueToRender(context, (UIComponent)button));
        boolean disabled = button.isDisabled();
        String inputId = clientId + "_input";
        String label = checked ? button.getOnLabel() : button.getOffLabel();
        String icon = checked ? button.getOnIcon() : button.getOffIcon();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)button.resolveStyleClass(checked, disabled), null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (button.getTitle() != null) {
            writer.writeAttribute("title", (Object)button.getTitle(), null);
        }
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "style");
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (button.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)button.getOnchange(), null);
        }
        writer.endElement("input");
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + icon), null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.writeText((Object)label, "value");
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectBooleanButton button) throws IOException {
        String clientId = button.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectBooleanButton", button.resolveWidgetVar(), clientId).attr("onLabel", this.escapeText(button.getOnLabel())).attr("offLabel", this.escapeText(button.getOffLabel())).attr("onIcon", button.getOnIcon(), null).attr("offIcon", button.getOffIcon(), null);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)button);
        wb.finish();
    }
}

