/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.media;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.media.Media;
import org.primefaces.component.media.player.MediaPlayer;
import org.primefaces.component.media.player.MediaPlayerFactory;
import org.primefaces.context.RequestContext;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.StringEncrypter;

public class MediaRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String src;
        Media media = (Media)component;
        MediaPlayer player = this.resolvePlayer(context, media);
        ResponseWriter writer = context.getResponseWriter();
        try {
            src = this.getMediaSrc(context, media);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        boolean isIE = AgentUtils.isIE(context);
        String sourceParam = player.getSourceParam();
        writer.startElement("object", (UIComponent)media);
        writer.writeAttribute("type", (Object)player.getType(), null);
        writer.writeAttribute("data", (Object)src, null);
        if (isIE) {
            this.encodeIEConfig(writer, player);
        }
        if (media.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)media.getStyleClass(), null);
        }
        this.renderPassThruAttributes(context, (UIComponent)media, HTML.MEDIA_ATTRS);
        if (sourceParam != null) {
            this.encodeParam(writer, player.getSourceParam(), src, false);
        }
        for (UIComponent child : media.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            this.encodeParam(writer, param.getName(), param.getValue(), false);
        }
        this.renderChildren(context, (UIComponent)media);
        writer.endElement("object");
    }

    protected void encodeIEConfig(ResponseWriter writer, MediaPlayer player) throws IOException {
        writer.writeAttribute("classid", (Object)player.getClassId(), null);
        if (player.getCodebase() != null) {
            writer.writeAttribute("codebase", (Object)player.getCodebase(), null);
        }
    }

    protected void encodeParam(ResponseWriter writer, String name, Object value, boolean asAttribute) throws IOException {
        if (value == null) {
            return;
        }
        if (asAttribute) {
            writer.writeAttribute(name, value, null);
        } else {
            writer.startElement("param", null);
            writer.writeAttribute("name", (Object)name, null);
            writer.writeAttribute("value", (Object)value.toString(), null);
            writer.endElement("param");
        }
    }

    protected MediaPlayer resolvePlayer(FacesContext context, Media media) {
        if (media.getPlayer() != null) {
            return MediaPlayerFactory.getPlayer(media.getPlayer());
        }
        if (media.getValue() instanceof String) {
            Map<String, MediaPlayer> players = MediaPlayerFactory.getPlayers();
            String[] tokens = ((String)media.getValue()).split("\\.");
            String type = tokens[tokens.length - 1];
            for (MediaPlayer mp : players.values()) {
                for (String supportedType : mp.getSupportedTypes()) {
                    if (!supportedType.equalsIgnoreCase(type)) continue;
                    return mp;
                }
            }
        }
        throw new IllegalArgumentException("Cannot resolve mediaplayer for media component '" + media.getClientId(context) + "', cannot play source:" + media.getValue());
    }

    protected String getMediaSrc(FacesContext context, Media media) throws Exception {
        String src;
        Object value = media.getValue();
        if (value == null) {
            src = null;
        } else {
            if (value instanceof StreamedContent) {
                StreamedContent streamedContent = (StreamedContent)value;
                Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent.properties", "primefaces", streamedContent.getContentType());
                String resourcePath = resource.getRequestPath();
                StringEncrypter strEn = RequestContext.getCurrentInstance().getEncrypter();
                String rid = strEn.encrypt(media.getValueExpression("value").getExpressionString());
                StringBuilder builder = new StringBuilder(resourcePath);
                builder.append("&").append("pfdrid").append("=").append(URLEncoder.encode(rid, "UTF-8"));
                for (UIComponent kid : media.getChildren()) {
                    if (!(kid instanceof UIParameter)) continue;
                    UIParameter param = (UIParameter)kid;
                    Object paramValue = param.getValue();
                    builder.append("&").append(param.getName()).append("=");
                    if (paramValue == null) continue;
                    builder.append(URLEncoder.encode(param.getValue().toString(), "UTF-8"));
                }
                src = context.getExternalContext().encodeResourceURL(builder.toString());
            } else {
                src = this.getResourceURL(context, (String)value);
                if (src.startsWith("/")) {
                    src = context.getExternalContext().encodeResourceURL(src);
                }
            }
            src = src + (src.contains("?") ? "&" : "?");
            src = src + "pfdrid_c=" + media.isCache();
        }
        return src;
    }

    protected String generateKey() {
        StringBuilder builder = new StringBuilder();
        return builder.append("pfdrid").append("_").append(UUID.randomUUID().toString()).toString();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

