// Zmienna globalna przechowujca odwoanie do wybranego elementu
var wybranyObiekt;

// Zmienne globalne przechwujce wzgldne wsprzdne kliknicia 
// (wyznaczane w odniesieniu do pooenia elementu)
var przesX, przesY;

// Ustawienie globalnej referencji aktywnego lub przeciganego obiektu
function wybranyElement(zdarzenie) {
    var cel = (zdarzenie.target) ? zdarzenie.target : zdarzenie.srcElement;
    var idDiv = (cel.name && cel.src) ? cel.name + "Otocz" : "";
    if (idDiv) {
        if (document.layers) {
            wybranyObiekt = document.layers[idDiv];
        } else if (document.all) {
            wybranyObiekt = document.all(idDiv);
        } else if (document.getElementById) {
            wybranyObiekt = document.getElementById(idDiv);
        }
        podajIndeksZ(wybranyObiekt, 100);
        return;
    }
    wybranyObiekt = null;
    return;
}

// Uaktywnienie wybranego elementu
function wlacz(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie: event;
    wybranyElement(zdarzenie);
    if (wybranyObiekt) {
        if (document.body && document.body.setCapture) {
            // wczenie przechwytywania zdarze w IE/Win
            document.body.setCapture();
        }
        if (zdarzenie.pageX) {
            przesX = zdarzenie.pageX - ((wybranyObiekt.offsetLeft) ? 
                     wybranyObiekt.offsetLeft : wybranyObiekt.left);
            przesY = zdarzenie.pageY - ((wybranyObiekt.offsetTop) ? 
                     wybranyObiekt.offsetTop : wybranyObiekt.top);
        } else if (typeof zdarzenie.offsetX != "undefined") {
            przesX = zdarzenie.offsetX - ((zdarzenie.offsetX < -2) ? 
                     0 : document.body.scrollLeft);
            przesX -= (document.body.parentElement && 
                     document.body.parentElement.scrollLeft) ? 
                     document.body.parentElement.scrollLeft : 0
            przesY = zdarzenie.offsetY - ((zdarzenie.offsetY < -2) ? 
                     0 : document.body.scrollTop);
            przesY -= (document.body.parentElement && 
                     document.body.parentElement.scrollTop) ? 
                     document.body.parentElement.scrollTop : 0
        } else if (typeof zdarzenie.clientX != "undefined") {
            przesX = zdarzenie.clientX - ((wybranyObiekt.offsetLeft) ? 
                     wybranyObiekt.offsetLeft : 0);
            przesY = zdarzenie.clientY - ((wybranyObiekt.offsetTop) ? 
                     wybranyObiekt.offsetTop : 0);
        }
        return false;
    }
}



// Przeciganie elementu
function przeciagnij(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie: event;
    if (wybranyObiekt) {
        if (zdarzenie.pageX) {
            przesunDo(wybranyObiekt, (zdarzenie.pageX - przesX), (zdarzenie.pageY - przesY));
        } else if (zdarzenie.clientX || zdarzenie.clientY) {
            przesunDo(wybranyObiekt, (zdarzenie.clientX - przesX), (zdarzenie.clientY - przesY));
        }
        zdarzenie.cancelBubble = true;
        return false;
    }
}

// Zwolnienie elementu
function zwolnij(zdarzenie) {
    if (wybranyObiekt) {
        podajIndeksZ(wybranyObiekt, 0);
        if (document.body && document.body.releaseCapture) {
            // zatrzymanie przechwytywania zdarze w IE/Win
            document.body.releaseCapture();
        }
        wybranyObiekt = null;
    }
}

// Przypisanie procedur obsugi zdarze przegldarek Internet Explorer i Netscape Navigator
function inicjujPrzeciaganie() {
    if (document.layers) {
        // wczenie przechwytywania poniszych zdarze w modelu zdarze NN4
        document.captureEvents(Event.MOUSEDOWN | Event.MOUSEMOVE | Event.MOUSEUP);
        return;
    } else if (document.body & document.body.addEventListener) {
        // wczenie przechwytywania poniszych zdarze w modelu zdarze DOM W3C
    	document.addEventListener("mousedown", wlacz, true);
    	document.addEventListener("mousemove", przeciagnij, true);
    	document.addEventListener("mouseup", zwolnij, true);
    	return;
    }
  	document.onmousedown = wlacz;
   	document.onmousemove = przeciagnij;
   	document.onmouseup = zwolnij;
    return;
}

