# przykad 10.3 z punktu 10.1.3 
# (przykad 10.3 z punktu 10.1.3)  : Zaawansowane metody uczenia maszynowego : Metody drzewa : Dalsze usprawnianie przewidywa za pomoc lasw losowych 
# Tytu: Korzystanie z lasw losowych 

library(randomForest)                                   	# Uwaga 1. 
set.seed(5123512)                                     	# Uwaga 2. 
fmodel <- randomForest(x = spamTrain[, spamVars],       	# Uwaga 3. 
                       y = spamTrain$spam,
                       ntree = 100,                                   	# Uwaga 4. 
                       nodesize = 7,                                  	# Uwaga 5. 
                       importance = TRUE)                             	# Uwaga 6. 

pred <- predict(fmodel, 
                spamTrain[, spamVars], 
                type = 'prob')[, 'spam']

trainperf_rf <-  accuracyMeasures(predict(fmodel,      	# Uwaga 7. 
                                          newdata = spamTrain[, spamVars], type = 'prob')[, 'spam'],
                                  spamTrain$spam == "spam", name = "las losowy, uczacy")

testperf_rf <-  accuracyMeasures(predict(fmodel,
                                         newdata = spamTest[, spamVars], type = 'prob')[, 'spam'],
                                 spamTest$spam == "spam", name = "las losowy, testowy")

perftable <- rbind(trainperf_rf, testperf_rf)
pandoc.table(perftable, justify = perf_justify)

## 
## 
## model                    accuracy       f1   dev.norm
## ---------------------- ---------- -------- ----------
## las losowy, uczacy         0.9884   0.9852     0.1440
## las losowy, testowy        0.9498   0.9341     0.3011

# Uwaga 1. 
#   Wczytuje pakiet randomForest. 

# Uwaga 2. 
#   Wyznacza ziarno pseudolosowoci, dziki czemu bdzie wyrasta za kadym razem taki sam las losowy. 

# Uwaga 3. 
#   Wywouje funkcj randomForest(), ktra tworzy model; zmienne objaniajce s w nim oznaczone jako x, a przewidywana kategoria jako y. 

# Uwaga 4. 
#   Wykorzystuje 100 drzew, dziki czemu model ten jest kompatybilny z naszym przykadem agregacji. Domylna warto to 500 drzew. 

# Uwaga 5. 
#   Sprawia, e kady wze drzewa musi zawiera co najmniej 7 elementw, aby by kompatybilny z minimalnym rozmiarem wza, wykorzystywanym przez funkcj rpart() na tym zbiorze uczcym. 

# Uwaga 6.
#   Dziki temu algorytm bdzie zachowywa informacje uywane do obliczania istotnoci zmiennych (zostanie to omwione w dalszej czci rozdziau). 

# Uwaga 7. 
#   Okrela jako modelu. 

