# przykad 9.15 z punktu 9.1.5 
# (przykad 9.15 z punktu 9.1.5)  : Metody nienadzorowane : Analiza skupie : Przypisywanie nowych punktw do skupie 
# Tytu: Generowanie danych syntetycznych i analiza ich skupie 

mean1 <- c(1, 1, 1)                                  	# Uwaga 1. 
sd1 <- c(1, 2, 1)

mean2 <- c(10, -3, 5)
sd2 <- c(2, 1, 2)

mean3 <- c(-5, -5, -5)
sd3 <- c(1.5, 2, 1)

library(MASS)                                       	# Uwaga 2. 
clust1 <- mvrnorm(100, mu = mean1, Sigma = diag(sd1))
clust2 <- mvrnorm(100, mu = mean2, Sigma = diag(sd2))
clust3 <- mvrnorm(100, mu = mean3, Sigma = diag(sd3))
toydata <- rbind(clust3, rbind(clust1, clust2))

tmatrix <- scale(toydata)                          	# Uwaga 3. 
tcenter <- attr(tmatrix, "scaled:center")           	# Uwaga 4. 
tscale <-attr(tmatrix, "scaled:scale")
tmatrix <- rm_scales(tmatrix)

kbest_t <- 3
tclusters <- kmeans(tmatrix, kbest_t, nstart = 100, iter.max = 100)     	# Uwaga 5. 

tclusters$size                                   	# Uwaga 6.        
## [1] 101 100  99

# Uwaga 1. 
#   Wyznacza parametry trzech trjwymiarowych skupie o rozkadzie gaussowskim. 

# Uwaga 2. 
#   Wykorzystuje funkcj mvrnorm() z pakietu MASS do generowania trjwymiarowych skupie o rozkadzie gaussowskim, wyrwnanych do osi wsprzdnych. 

# Uwaga 3. 
#   Skaluje dane syntetyczne. 

# Uwaga 4. 
#   Uzyskuje atrybuty skalowania, a nastpnie usuwa je z macierzy. 

# Uwaga 5. 
#   Grupuje dane syntetyczne w trzy skupienia.

# Uwaga 6. 
#   Wygenerowane skupienia s zgodne rozmiarem z rzeczywistymi skupieniami. 

