# przykad B.8 z punktu B.1.4 
# (przykad B.8 z punktu B.1.4)  : Wane pojcia z dziedziny statystyki : Rozkady : Rozkad dwumianowy 
# Tytu: Praca z teoretycznym rozkadem dwumianowym 

p = 0.5 # odsetek kobiet w populacji studentw
class_size <- 20 # rozmiar sali lekcyjnej
numclasses <- 100 # liczba obserwowanych klas

# jak moe wyglda typowy wynik?
numFemales <- rbinom(numclasses, class_size, p) 	# Uwaga 1. 

# teoretyczne liczebnoci (niekoniecznie liczba cakowita)
probs <- dbinom(0:class_size, class_size, p)
tcount <- numclasses*probs

# oczywistym rozwizaniem byoby wygenerowanie histogramu lub obiektu geom_bar,
# ale nasz wykres bdzie po prostu prezentowa si lepiej

zero <- function(x) {0} # zmienna fikcyjna, zwracajca wycznie 0

ggplot(data.frame(number_of_girls = numFemales, dummy = 1),
       aes(x = number_of_girls, y = dummy)) + 
  # zlicza liczb x zaobserwowanych reszek
  stat_summary(fun.y = "sum", geom = "point", size=2) + 	# Uwaga 2. 
  stat_summary(fun.ymax = "sum", fun.ymin = "zero", geom = "linerange") + 
  # nakada teoretyczn liczb x zaobserwowanych reszek
  geom_line(data = data.frame(x = 0:class_size, y = tcount),
            aes(x = x, y = y), linetype = 2) +
  scale_x_continuous(breaks = 0:class_size, labels = 0:class_size) +
  scale_y_continuous("Liczba sal lekcyjnych")

# Uwaga 1. 
#   Nie wyznaczylimy parametru set.seed, dlatego za kadym razem bdziemy uzyskiwa inne rezultaty. 

# Uwaga 2. 
#   Funkcja stat_summary stanowi jeden ze sposobw kontrolowania agregacji danych w czasie tworzenia wykresu. W tym przypadku uywamy jej do wstawienia wykresu kolumnowo-punktowego na podstawie danych empirycznych, wraz z teoretyczn krzyw gstoci. 

