# przykad 4.13 z punktu 4.3.3 
# (przykad 4.13 z punktu 4.3.3)  : Zarzdzanie danymi : Losowanie danych do modelowania i walidacji : Grupowanie rekordw 
# Tytu: Rozdzielanie danych na zbir uczcy/testowy z uwzgldnieniem zachowania czonkw rodziny w jednej grupie 

household_data <- readRDS("Custdata/hhdata.RDS")            	# Uwaga 1.  
hh <- unique(household_data$household_id)              	# Uwaga 2.

set.seed(243674)
households <- data.frame(household_id = hh,            	# Uwaga 3.  
                         gp = runif(length(hh)),
                         stringsAsFactors=FALSE)

household_data <- dplyr::left_join(household_data,     	# Uwaga 4.
                                   households,
                                   by = "household_id")

# Uwaga 1. 
#   Jeeli pobrae katalog PDWsR2, to omawiany zestaw danych znajduje si w podkatalogu PDSwR2/Custdata. Przyjmujemy, e jest to Twj katalog roboczy 

# Uwaga 2. 
#   Pobiera niepowtarzalne identyfikatory rodzin. 

# Uwaga 3. 
#   Generuje niepowtarzalny identyfikator grupowania prby dla kadej rodziny i wstawia kolumn o nazwie gp. 

# Uwaga 4. 
#   Docza identyfikatory rodzin do pierwotnych danych. 

