% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoLog10.R
\name{pseudoLog10}
\alias{pseudoLog10}
\title{Zwraca pseudologarytm dziesietny.}
\usage{
pseudoLog10(x)
}
\arguments{
\item{x}{wektor numeryczny}
}
\value{
pseudologarytm dziesietny x
}
\description{
Zwraca pseudologarytm (dziesietny) zmiennej x, co daje w przyblizeniu wartosc
sign(x)*log10(abs(x)) dla takiego x, ktorego abs(x) ma duza wartosc
i nie "eksploduje" w poblizu zera.  Rozwiazanie to przydaje sie
podczas przeksztalcania zmiennych o szerokim zakresie, ktore moga przyjmowac
wartosci ujemne (na przyklad zysk/strata).
}
\details{
Zobacz: \url{http://www.win-vector.com/blog/2012/03/modeling-trick-the-signed-pseudo-logarithm/}

Uwaga: z przeksztalceniem tym wiaze sie niepozadany skutek uboczny, w wyniku ktorego wiekszosc
rozkladow okreslonych znakiem wydaje sie byc bimodalnych w okolicach srodka ukladu wspolrzednych
bez wzgledu na rzeczywisty ksztalt rozkladu.
Zakladamy, ze argument x jest numeryczny i moze byc wektorem.
}
\examples{

pseudoLog10(c(-5, 0, 5))
# powinienes otrzymac nastepujace wyniki: [1] -0.7153834  0.0000000  0.7153834

}
