



# Przykładowe kod i dane współtowarzyszące książce "Język R i analiza danych w praktyce. Wydanie II"  autorstwa Niny Zumel i Johna Mounta.


Niniejsza książka będzie dla Ciebie przydatna, jeśli jesteś analitykiem danych, chcesz zostać
analitykiem danych lub chcesz pracować z analitykami danych. Jest to znakomity poradnik dla
analityków i programistów chcących uzyskać informacje na temat uczenia maszynowego 
i przygotowywania danych.


Naszym zadaniem jest zaprezentowanie analizy danych z pragmatycznej i praktycznej strony.
Książka uzupełnia informacje zawarte w książkach poświęconych statystyce, analityce, 
uczeniu maszynowemu, analizie danych i językowi R o następujące elementy:

-   Nauczysz się pracować jako analityk danych (ang. data scientist). Zrozumiesz,
    jak ważną rolę odgrywają w tym zawodzie umiejętności słuchania, współpracowania,
    uczciwe prezentowanie wyników i powtarzalność.
-   Największy nacisk zostaje położony na proces: określanie wymogów,
    wczytywanie danych, sprawdzanie ich poprawności, budowanie modeli, sprawdzanie ich poprawności,
    dokumentowanie modeli i wdrażanie ich do środowiska produkcyjnego.
-   Prezentujemy ponad dziesięć przykładowych zestawów danych i demonstrujemy omawiane pojęcia
    na przemyślanych ćwiczeniach wykorzystujących standardowe metody R.
    Uważamy, że takie rozwiązanie pozwala nam ilustrować w łatwy sposób przekazywaną wiedzę 
    i demonstrować wszystkie etapy przygotowawcze, niezbędne w każdym prawdziwym projekcie.
    Wszystkie wyniki i niemal wszystkie wykresy ukazane w książce można otrzymać za pomocą
    tych ćwiczeń.
-   Dane statystyczne zostały tu starannie przygotowane, ale zagadnienia są przedstawiane w kontekście
    służącym adeptom analizy danych. Na przykład kładziemy nacisk na konstruowanie modeli
    predykcyjnych oraz ocenianie modelu i przewidywań, a nie na standardowe zagadnienia
    statystyki podsumowującej czy procedur pakietowych. 

W ramach materiałów dodatkowych przygotowaliśmy:

-   [Publiczne repozytorium zestawów danych](https://github.com/WinVector/PDSwR2) (tam, 
    gdzie możliwe, objęte licencją Uznanie autorstwa - Użycie niekomercyjne 3.0 Unported).
-   [Przykładowy kod](https://github.com/WinVector/PDSwR2/tree/master/CodeExamples) do pobrania.


Więcej informacji o książce (w języku angielskim) znajdziesz w następujących artykułach:

-   [How does Practical Data Science with R stand out?](http://www.win-vector.com/blog/2014/06/how-does-practical-data-science-with-r-stand-out/)
-   [On Writing Our Book: A Little Philosophy](http://www.win-vector.com/blog/2013/05/on-writing-our-book-a-little-philosophy/)



## Materiały dodatkowe

 * Dodatek A z książki, opisujący proces instalacji wymaganego oprogramowania i pakietów: [Korzystanie z R i innych narzędzi.pdf](Korzystanie_z_R_i_innych_narzędzi.pdf).
 * Strona z materiałami dodatkowymi (kodem i danymi): [GitHub WinVector/PDSwR2](https://github.com/WinVector/PDSwR2).

## Wszystkie listingi:

 * KodPrzykłady.zip
 * Katalog z listingami (Listingi)
 * Gotowe przykłady (GotowePrzyklady)


## Materiały od autorów:

 * [Blog Win-Vector](http://www.win-vector.com/blog/)
 * [WinVectorLLC na Twitterze](https://twitter.com/WinVectorLLC)
 * [Strona domowa Niny Zumel](http://ninazumel.com/)
 * [Strona domowa Johna Mounta](http://johnmount.com/)
 * [Win-Vector: usługi doradcze w zakresie analizy danych](http://www.win-vector.com/index.html)

## Przykładowe zestawy danych:

Projekty opracowane na przez innych twórców (zestawów danych) podlegają kontroli przez nich. Rozpowszechniamy niniejszy kod za ich przyzwoleniem i nie zgłaszamy żadnych roszczeń ani nie przyznajemy dodatkowych praw lub licencji.

 * biodostepnosc (bioavailability): syntetyczne, proste dane [ADME](http://en.wikipedia.org/wiki/ADME) ([źródło](http://www.cyprotex.com/admepk/in-vitro-permeability/caco-2-permeability/)).
 * Bookdata: opinie o książkach ([źródło](http://www.informatik.uni-freiburg.de/~cziegler/BX/)).
 * Buzz: popularność na forach dyskusyjnych ([źródło](http://ama.liglab.fr/datasets/buzz/)).
 * CDC: statystyki urodzeń w Stanach Zjednoczonych (na podstawie danych agencji CDC) ([źródło](http://www.cdc.gov/nchs/data_access/Vitalstatsonline.htm)).
 * Custdata: syntetyczne dane przykładowe, utworzone na podstawie danych biura cenzusowego PUMS, ukazujące wykresy związane ze sprzedażą detaliczną.
 * KDD2009: przewidywanie dla kont kredytowych ([źródło](http://www.sigkdd.org/kdd-cup-2009-customer-relationship-prediction)).
 * PUMS: dane amerykańskiego biura cenzusowego PUMS ([źródło](http://www.census.gov/acs/www/data_documentation/pums_data/)).
 * Protein: spożycie źródeł białka w poszczególnych państwach ([źródło](http://lib.stat.cmu.edu/DASL/Datafiles/Protein.html)).
 * SQLExample: syntetyczne, przykładowe dane ukazujące relację pomiędzy ceną a rezerwacją pokoju w hotelu.
 * Spambase: klasyfikacja wiadomości e-mailowych ([źródło](http://archive.ics.uci.edu/ml/datasets/Spambase)).
 * Statlog: niespłacone kredyty w Niemczech ([źródło](http://archive.ics.uci.edu/ml/machine-learning-databases/statlog/german/)).
 * UCICar: syntetyczne oceny samochodów ([źródło](http://archive.ics.uci.edu/ml/machine-learning-databases/car/)).


## Pobieranie

Wersję oryginalną możesz pobrać z głównego repozytorium [github.com/WinVector/PDSwR2](https://github.com/WinVector/PDSwR2) za pomocą instrukcji "git clone" lub "download zip".

Instrukcję instalacji znajdziesz [tutaj](Korzystanie_z_R_i_innych_narzędzi.pdf).

## Licencja obejmująca dodatkowe dokumentację, uwagi, kod i dane pochodne: 

<a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/deed.pl"><img alt="Creative Commons License" style="border-width:0" src="http://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />Niniejsze dzieło jest objęte licencją <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Uznanie autorstwa - Użycie niekomercyjne - Na tych samych warunkach 4.0 Międzynarodowe</a>.

Żaden z tych elementów nie jest objęty gwarancją, ubezpieczeniem ani roszczeniem działania.

Licencja nie obejmuje projektów osób trzeci ani danych pochodnych.


