# przykad B.6 z punktu B.1.3 
# (przykad B.6 z punktu B.1.3)  : Wane pojcia z dziedziny statystyki : Rozkady : Rozkad logarytmicznie normalny 
# Tytu: Tworzenie wykresu rozkadu logarytmicznie normalnego 

# 50. percentyl (mediana) rozkadu logarytmicznie normalnego
# (meanlog=0 and sdlog=10)
qlnorm(0.5)
# [1] 1
# prawdopodobiestwo zaobserwowania wartoci x mniejszej od 1
plnorm(1)
# [1] 0.5

# prawdopodobiestwo zaobserwowania wartoci x mniejszej od 10
plnorm(10)
# [1] 0.9893489

# -- ukazuje 75. percentyl rozkadu logarytmicznie normalnego 

# wykorzystuje ramk danych lnormframe z poprzedniego listingu: 
# krzywa teoretycznego rozkadu logarytmicznie normalnego

line <- qlnorm(0.75)
xstr <- sprintf("qlnorm(0.75) = %1.3f", line)

lnormframe75 <- subset(lnormframe, lnormframe$x < line)

# Tworzy wykres 
# Zacieniony obszar stanowi 75% powierzchni pod krzyw rozkadu logarytmicznie normalnego
ggplot(lnormframe, aes(x = x, y = y)) + geom_line() +
  geom_area(data=lnormframe75, aes(x = x, y = y), fill = "gray") + 
  geom_vline(aes(xintercept = line), linetype = 2) +
  geom_text(x = line, y = 0, label = xstr, hjust = 0, vjust = 1)

