# przykad B.4 z punktu B.1.1 
# (przykad B.4 z punktu B.1.1)  : Wane pojcia z dziedziny statystyki : Rozkady : Rozkad normalny 
# Tytu: Tworzenie wykresu x < qnorm(0.75)

# --- zwraca kwantyle odpowiadajce okrelonym prawdopodobiestwom ---

# mediana (50. percentyl) rozkadu normalnego jest jednoczenie jego redni
qnorm(0.5)
# [1] 0

# oblicza 75. percentyl
qnorm(0.75)
# [1] 0.6744898
pnorm(0.6744898)
# [1] 0.75

# --- Ukazanie 75. percentyla na wykresie ---

# tworzy wykres rozkadu normalnego (mean = 0, sd = 1)
x <- seq(from=-5, to=5, length.out=100)
f <- dnorm(x)
nframe <- data.frame(x=x,y=f) 

# oblicza 75. percentyl
line <- qnorm(0.75)
xstr <- sprintf("qnorm(0.75) = %1.3f", line)

# obszar rozkadu normalnego na lewo od
# 75. percentyla
nframe75 <- subset(nframe, nframe$x < line)

# tworzy wykres 
# zacieniony obszar ukazuje 75% powierzchni pod krzyw rozkadu normalnego
ggplot(nframe, aes(x=x,y=y)) + geom_line() +
  geom_area(data=nframe75, aes(x=x,y=y), fill="gray") + 
  geom_vline(aes(xintercept=line), linetype=2) +
  geom_text(x=line, y=0, label=xstr, vjust=1)

