# przykad 7.1 z punktu 7.1.1 
# (przykad 7.1 z punktu 7.1.1)  : Regresja liniowa i logistyczna : Stosowanie regresji liniowej : Mechanizm dziaania regresji liniowej
# Tytu: Wczytywanie danych PUMS i dopasowanie modelu 

psub <- readRDS("PUMS/psub.RDS")

set.seed(3454351)     
gp <- runif(nrow(psub))                                            	# Uwaga 1. 

dtrain <- subset(psub, gp >= 0.5)                                	# Uwaga 2.
dtest <- subset(psub, gp < 0.5)

model <- lm(log10(PINCP) ~ AGEP + SEX + COW + SCHL, data = dtrain)  	# Uwaga 3. 
dtest$predLogPINCP <- predict(model, newdata = dtest)              	# Uwaga 4. 
dtrain$predLogPINCP <- predict(model, newdata = dtrain)

# Uwaga 1. 
#   Tworzy zmienn losow suc do grupowania i dzielenia danych. 

# Uwaga 2. 
#   Dzieli dane na zbiory uczcy i testowy w stosunku 1:1. 

# Uwaga 3. 
#   Dopasowuje model liniowy do funkcji log(dochody).  

# Uwaga 4. 
#   Oblicza przewidywane wyniki funkcji log(dochody) na zbiorach uczcym i testowym. 

