
library(randomForest)

loglikelihood <- function(y, py) {
  pysmooth <- ifelse(py == 0, 1e-12,
                     ifelse(py == 1, 1-1e-12, py))
  sum(y * log(pysmooth) + (1 - y) * log(1 - pysmooth))
}

# Funkcja renderTable wywołuje metodę as.data.table() wobec macierzy pomyłek, co
# powoduje zmianę wyglądu tej macierzy.
# Z tego powodu przekształcamy ją ręcznie w macierz (o właściwych wymiarach)
# i nadajemy jej czytelne nazwy kolumn oraz rzędów.
reformatCM <- function(confusionMat) {
  confusionMat <- unclass(confusionMat) # przekształca w macierz
  
  # zmienia nazwy kolumn i rzędów w bardziej czytelną formę
  rownames(confusionMat) <- c("rzeczyw.: FALSE", "rzeczyw.: TRUE")
  colnames(confusionMat) <- c("przewid.: FALSE", "przewid.: TRUE")
  confusionMat
}

# zwraca wskaźniki wydajności modelu
accuracyMeasures <- function(pred, truth, threshold=0.5) {
  
  # prowizoryczne rozwiązanie obługujące granice progów
  if(threshold >= max(pred)) {
    threshold = max(pred) - 0.0001
  }
  if(threshold <= min(pred)) {
    threshold = min(pred) + 0.0001
  }
  
  ctable <- table(truth = truth,
                  pred = pred > threshold)

  accuracy <- sum(diag(ctable)) / sum(ctable)
  precision <- ctable[2, 2] / sum(ctable[, 2])
  recall <- ctable[2, 2] / sum(ctable[2, ])
  f1 <- 2 * precision * recall / (precision + recall)

  list(perfmetrics =  data.frame(accuracy = accuracy, 
                                 precision = precision,
                                 recall = recall,
                                 f1 = f1),
       confmat = reformatCM(ctable))
}
