// obiekt sound
sound = function(){
	
	// Pobieranie dźwięku
	this.preload = function(url){
		this.audio = new Audio();
		//this.audio.setAttribute("src", url + this.ext);
		this.audio.preload = "auto";
		this.audio.src = url + sound.ext;
		this.audio.load();
	};
	
	// Zwraca true jeśli dźwięk został pobrany
	this.isPreloaded = function(){
		return (this.audio.readyState == 4)
	}
	
	// Rozpoczyna odtwarzanie dźwięku. 
	// Jeśli loop == true dźwięk będzie odtwarzany w pętli 
	this.play = function(loop){
		if (this.audio.lopp === undefined){
			this.audio.addEventListener('ended', function() {
			    this.currentTime = 0;
			    this.play();
			}, false);
		} else {
			this.audio.loop = loop;
		}
		this.audio.play();
	};
	
	// Wstrzymuje odtwarzanie
	this.pause = function(loop){
		this.audio.pause();
	};
	
	// Zatrzymuje odtwarzanie
	this.stop = function(){
		this.audio.pause();
		this.audio.currentTime = 0;
	};
};

(function(){
	var audio = new Audio();
	var canPlayOggVorbis = audio.canPlayType('audio/ogg; codecs="vorbis"');
	var canPlayMP3 = audio.canPlayType('audio/mpeg; codecs="mp3"');
	if (canPlayOggVorbis == "probably" || (canPlayOggVorbis == "maybe" && canPlayMP3 != "probably")) {
		sound.ext = ".ogg";
	} else {
		sound.ext = ".mp3";
	}
})();
