<?php
/*
 * @package Joomla 1.5
 * @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 *
 * @module Phoca - Phoca Gallery Module
 * @copyright Copyright (C) Jan Pavelka www.phoca.cz
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
 
defined('_JEXEC') or die('Restricted access');// no direct access

//include_once( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_phocagallery'.DS.'assets'.DS.'phoca_config.php' );
include_once( JPATH_SITE.DS.'components'.DS.'com_phocagallery'.DS.'helpers'.DS.'phocagallery.php' );

$user =& JFactory::getUser();
$db =& JFactory::getDBO();
$menu 	= &JSite::getMenu();
$document	= & JFactory::getDocument();
		
//START CSS
		$document->addStyleSheet(JURI::base(true).'/components/com_phocagallery/assets/phocagallery.css');
		$document->addCustomTag("<!--[if IE]>\n<link rel=\"stylesheet\" href=\"".JURI::base(true)."/components/com_phocagallery/assets/phocagalleryieall.css\" type=\"text/css\" />\n<![endif]-->");


$paramsC = JComponentHelper::getParams('com_phocagallery') ;

// Variables ----------------------------------------------------------------------------
//Display Description in Detail window ---
$display_description_detail = 0;
if ($paramsC->get( 'display_description_detail' ) != '') {
	$display_description_detail = $paramsC->get( 'display_description_detail' );
}

//Display Description in Detail window - set the height of description text
$description_detail_height = 16;
if ($paramsC->get( 'description_detail_height' ) != '') {
	$description_detail_height = $paramsC->get( 'description_detail_height' );
}

// Image categories
$img_cat_size			= 'medium';

// Font
$font_color = '#135cae';
if ($paramsC->get( 'font_color' ) != '') {
	$font_color = $paramsC->get( 'font_color' );
}

$background_color = '#fcfcfc';
if ($paramsC->get( 'background_color' ) != '') {
	$background_color = $paramsC->get( 'background_color' );
}

$background_color_hover = '#f5f5f5';
if ($paramsC->get( 'background_color_hover' ) != '') {
	$background_color_hover = $paramsC->get( 'background_color_hover' );
}

$image_background_color = '#f5f5f5';
if ($paramsC->get( 'image_background_color' ) != '') {
	$image_background_color = $paramsC->get( 'image_background_color' );
}

$border_color = '#e8e8e8';
if ($paramsC->get( 'border_color' ) != '') {
	$border_color = $paramsC->get( 'border_color' );
}

$border_color_hover = '#135cae';
if ($paramsC->get( 'border_color_hover' ) != '') {
	$border_color_hover = $paramsC->get( 'border_color_hover' );
}


//Display or hide name, icon detail link
$display_name = 1;
if ($paramsC->get( 'display_name' ) != '') {
	$display_name = $paramsC->get( 'display_name' );
}

$display_icon_detail = 1;
if ($paramsC->get( 'display_icon_detail' ) != '') {
	$display_icon_detail = $paramsC->get( 'display_icon_detail' );
}

$display_icon_download = 0;
if ($paramsC->get( 'display_icon_download' ) != '') {
	$display_icon_download = $paramsC->get( 'display_icon_download' );
}

//Fonts
$font_size_name = 12;
if ($paramsC->get( 'font_size_name' ) != '') {
	$font_size_name = $paramsC->get( 'font_size_name' );
}

$char_length_name = 11;
if ($paramsC->get( 'char_length_name' ) != '') {
	$char_length_name = $paramsC->get( 'char_length_name' );
}

//Open window parameters - modal popup box or standard popup window
$detail_window = 0;
if ($paramsC->get( 'detail_window' ) != '') {
	$detail_window = $paramsC->get( 'detail_window' );
}

//--------------------------------------------------------------------------------------------------

// height and width
// Get image height and width
$medium_image_width			=	100;
$medium_image_height		=	100;
$front_modal_box_width		=	680;
$front_modal_box_height		=	560;
$front_popup_window_width	=	680;
$front_popup_window_height	=	560;
if ($paramsC->get( 'medium_image_width' ) != '') {
	$medium_image_width = $paramsC->get( 'medium_image_width' );
}
if ($paramsC->get( 'medium_image_height' ) != '') {
	$medium_image_height = $paramsC->get( 'medium_image_height' );
}
if ($paramsC->get( 'front_modal_box_width' ) != '') {
	$front_modal_box_width = $paramsC->get( 'front_modal_box_width' );
}
if ($paramsC->get( 'front_modal_box_height' ) != '') {
	$front_modal_box_height = $paramsC->get( 'front_modal_box_height' );
}
if ($paramsC->get( 'front_popup_window_width' ) != '') {
	$front_popup_window_width = $paramsC->get( 'front_popup_window_width' );
}
if ($paramsC->get( 'front_popup_window_height' ) != '') {
	$front_popup_window_height = $paramsC->get( 'front_popup_window_height' );
}

// CSS
$image_background_shadow = 'none';
if ($paramsC->get( 'image_background_shadow' ) != '') {
	$image_background_shadow = $paramsC->get( 'image_background_shadow' );
}
		
if ( $image_background_shadow != 'none' ) {	
			$imageBgCSS = 'background: url(\''.JURI::base(true).'/components/com_phocagallery/assets/images/'.$image_background_shadow.'.'.PhocaGalleryHelper::getFormatIconComponent().'\') 0 0 no-repeat;';
} else {
	$imageBgCSS = 'background: '.$image_background_color .';';
}
	
$document->addCustomTag( "<style type=\"text/css\">\n"
						." #phocagallery-module .name {color: $font_color ;}\n"
						." #phocagallery-module .phocagallery-box-file {background: $background_color ; border:1px solid $border_color ;}\n"
						." #phocagallery-module .phocagallery-box-file-first { $imageBgCSS }\n"
						." #phocagallery-module .phocagallery-box-file:hover, .phocagallery-box-file.hover {border:1px solid $border_color_hover ; background: $background_color_hover ;}\n"
						." </style>\n");

$document->addCustomTag( "<!--[if IE]>\n<style type=\"text/css\">\n"
								."phocagallery-box-file{
background-color: expression(isNaN(this.js)?(this.js=1,
this.onmouseover=new Function(\"this.className+=' hover';\"),
this.onmouseout=new Function(\"this.className=this.className.replace(' hover','');\")):false););
}"
								." </style>\n<![endif]-->");

//END CSS

// Window
JHTML::_('behavior.modal', 'a.modal-button');
$button = new JObject();
$button->set('name', 'image');

if ($display_description_detail == 1) {
	$front_popup_window_height	= $front_popup_window_height + $description_detail_height;
}

//Display Buttons (height will be smaller)
$detail_buttons = 1;
if ($paramsC->get( 'detail_buttons' ) != '') {
	$detail_buttons = $paramsC->get( 'detail_buttons' );
}

if ($detail_buttons != 1) {
	$front_popup_window_height	= $front_popup_window_height - 45;
}

//standard popup window - get this from paramaters
if ($detail_window == 1) {
	$button->set('methodname', 'js-button');
	$button->set('options', "window.open(this.href,'win2','width=".$front_popup_window_width.",height=".$front_popup_window_height.",menubar=no,resizable=yes'); return false;");
	
} else { //modal popup box
	//Parameters
	$modal_box_overlay_color = '#000000';
	if ($paramsC->get( 'modal_box_overlay_color' ) != '') {
		$modal_box_overlay_color = $paramsC->get( 'modal_box_overlay_color' );
	}
	
	$modal_box_overlay_opacity = 0.7;
	if ($paramsC->get( 'modal_box_overlay_opacity' ) != '') {
		$modal_box_overlay_opacity = $paramsC->get( 'modal_box_overlay_opacity' );
	}
	
	$modal_box_border_color = '#000000';
	if ($paramsC->get( 'modal_box_border_color' ) != '') {
		$modal_box_border_color = $paramsC->get( 'modal_box_border_color' );
	}
	
	$modal_box_border_width = '10';
	if ($paramsC->get( 'modal_box_border_width' ) != '') {
		$modal_box_border_width = $paramsC->get( 'modal_box_border_width' );
	}
	
	$button->set('modal', true);
	$button->set('methodname', 'modal-button');
	$button->set('options', "{handler: 'iframe', size: {x: ".$front_popup_window_width.", y: ".$front_popup_window_height."}, overlayOpacity: ".$modal_box_overlay_opacity."}");
	
	$document->addCustomTag( "<style type=\"text/css\"> \n"  
	." #sbox-window {background-color:".$modal_box_border_color.";padding:".$modal_box_border_width."px} \n"
	." #sbox-overlay {background-color:".$modal_box_overlay_color.";} \n"			
	." </style> \n");
}
//----------------------------------------------

// QUERIES - count of files to make random number
/*$query = 'SELECT id' .
' FROM #__phocagallery' .
' WHERE published = 1' .
' ORDER BY RAND()';*/

$image = '';
$query = 'SELECT cc.id AS idcat, a.id AS idimage' .
' FROM #__phocagallery_categories AS cc' .
' LEFT JOIN #__phocagallery AS a ON a.catid = cc.id' .
' WHERE a.published = 1' .
' AND cc.published = 1' .
' ORDER BY RAND()';

$db->setQuery($query);
$image = $db->loadObject();

// QUERIES - all data we need to display the image
$query = 'SELECT cc.id, a.id, a.catid, a.title, a.alias, a.filename ,'
. ' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(\':\', cc.id, cc.alias) ELSE cc.id END as catslug, '
. ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(\':\', a.id, a.alias) ELSE a.id END as slug'
. ' FROM #__phocagallery_categories AS cc'
. ' LEFT JOIN #__phocagallery AS a ON a.catid = cc.id'
. ' WHERE a.id = ' . $image->idimage
. ' LIMIT 1';

$db->setQuery($query);
$image_object = $db->loadObject();


// -------------------------------------------------------------------- SEF PROBLEM
// Is there a Itemid for category
$items	 = $menu->getItems('link', 'index.php?option=com_phocagallery&view=category&id='.$image_object->id);
$itemscat= $menu->getItems('link', 'index.php?option=com_phocagallery&view=categories');


if(isset($itemscat[0]))
{
	$itemid = $itemscat[0]->id;
	//No JRoute now
	$image_object->link ='index.php?option=com_phocagallery&view=phocagalleryd&catid='. $image_object->catslug .'&id='. $image_object->slug .'&Itemid='.$itemid . '&tmpl=component&detail='.$detail_window.'&buttons='.$detail_buttons;
}
else if(isset($items[0]))
{
	$itemid = $items[0]->id;
	//No JRoute now
	$image_object->link = 'index.php?option=com_phocagallery&view=phocagalleryd&catid='. $image_object->catslug .'&id='. $image_object->slug .'&Itemid='.$itemid . '&tmpl=component&detail='.$detail_window.'&buttons='.$detail_buttons ;
}
else
{
	$itemid = 0;
	//No JRoute now
	$image_object->link = 'index.php?option=com_phocagallery&view=phocagalleryd&catid='. $image_object->catslug .'&id='. $image_object->slug . '&tmpl=component&detail='.$detail_window.'&buttons='.$detail_buttons ;
}
// ---------------------------------------------------------------------------------

// Path
$file_thumbnail = PhocaGalleryHelper::displayFileOrNoImage($image_object->filename, $img_cat_size);
$image_object->linkthumbnailpath = $file_thumbnail['rel'];
$image_object->linkthumbnailpathabs = $file_thumbnail['abs'];
// ---------------------------------------------------------------------------------



// Maximum size of module image is 100 x 100
jimport( 'joomla.filesystem.file' );
$imageWidth 	= 100;
$imageHeight	= 100;
if (JFile::exists($image_object->linkthumbnailpathabs))
{
	list($width, $height) = GetImageSize( $image_object->linkthumbnailpath );
	
	if ($width > $height) {
		if ($width > 100) {
			$imageWidth		= 100;
			$rate 			= $width / 100;
			$imageHeight	= $height / $rate;
		} else {
			$imageWidth		= $width;
			$imageHeight	= $height;
		}
	}
	else {
		if ($height > 100) {
			$imageHeight	= 100;
			$rate 			= $height / 100;
			$imageWidth 	= $width / $rate;
		} else {
			$imageWidth		= $width;
			$imageHeight	= $height;
		}
	}
}

$imageWidthBg 	= 100;	
$imageHeightBg	= 100;

// Display

$boxImageHeight = 100;
$boxImageWidth 	= 120;

if ($display_name == 1) {
	$boxImageHeight = $boxImageHeight + 20;
}

if ($display_icon_detail == 1 || $display_icon_download == 1 ) {
	$boxImageHeight = $boxImageHeight + 20;
}

if ( $image_background_shadow != 'none' ) {		
	$boxImageHeight = $boxImageHeight + 18;
	$imageWidthBg 	= 118;	
	$imageHeightBg	= 118;
}


$output = '<div class="phocagallery-box-file" style="height:'.$boxImageHeight.'px; width:'.$boxImageWidth.'px">' . "\n";
$output .= '<center>'  . "\n"
	.'<div class="phocagallery-box-file-first" style="height:'.$imageHeightBg.'px;width:'.$imageWidthBg.'px;">'. "\n"
	.'<div class="phocagallery-box-file-second">' . "\n"
	.'<div class="phocagallery-box-file-third">' . "\n"
	.'<center>' . "\n"
	.'<a class="'.$button->methodname.'" title="'.$image_object->title.'" href="'. JRoute::_($image_object->link).'"'; 
	
if ($detail_window == 1)
{
	$output .= ' onclick="'.$button->options.'"';// Standard Popup window
}
else
{
	$output .= ' rel="'.$button->options.'"';// Modal box
}


$output .= ' >' . "\n";
$output .= '<img src="'.$image_object->linkthumbnailpath.'" alt="'.$image_object->title.'" width="'.$imageWidth.'" height="'.$imageHeight.'" />';
$output .= '</a>'
	 .'</center>' . "\n"
	 .'</div>' . "\n"
	 .'</div>' . "\n"
	 .'</div>' . "\n"
	 .'</center>' . "\n";
	 

if ($display_name == 1)
{
	$output .= '<div class="name" style="text-align:center;color: '.$font_color.' ;font-size:'.$font_size_name.'px;">'.PhocaGalleryHelper::wordDelete($image_object->title, $char_length_name, '...').'</div>';
}

if ($display_icon_detail == 1 || $display_icon_download == 1)
{
	$output .= '<div class="detail" style="text-align:right">';
	
	if ($display_icon_detail == 1)
	{
		$output .= '<a class="'.$button->methodname.'" title="'. JText::_('Image Detail').'" href="'.JRoute::_($image_object->link).'"';
		if ($detail_window == 1)
		{
			$output .= ' onclick="'. $button->options.'"';
		}
		else
		{
			$output .= ' rel="'. $button->options.'"';
		}
		$output .= ' >';
		//$output .= JHTML::_('image', 'components/com_phocagallery/assets/images/icon-view....', $image->title);
		$output .= '<img src="components/com_phocagallery/assets/images/icon-view.'.PhocaGalleryHelper::getFormatIconComponent().'" alt="'.$image_object->title.'" />';
		$output .= '</a>';
	}

	
	if ($display_icon_download == 1)
	{
		$output .= '<a class="'. $button->methodname.'" title="'. JText::_('Image Download').'" href="'. JRoute::_($image_object->link . '&phocadownload=1').'"';
		if ($detail_window == 1)
		{
			$output .= ' onclick="'. $button->options.'"';
		}
		else
		{
			$output .= ' rel="'. $button->options.'"';
		}
		$output .= ' >';
		//$output .= JHTML::_('image', 'components/com_phocagallery/assets/images/icon-download....', $image->title);
		$output .= '<img src="components/com_phocagallery/assets/images/icon-download.'.PhocaGalleryHelper::getFormatIconComponent().'" alt="'.$image_object->title.'" />';
		$output .= '</a>';

	}
	
	$output .= '</div>';
}
	
$output .= '</div>';


require(JModuleHelper::getLayoutPath('mod_phocagallery_random_image'));			
?>