package com.journaler

import com.journaler.api.ApiApplication
import com.journaler.api.data.NoteDTO
import com.journaler.api.service.NoteService
import org.junit.Assert
import org.junit.Before
import org.junit.Test
import org.junit.runner.RunWith
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.test.context.SpringBootTest
import org.springframework.test.context.junit4.SpringRunner

@RunWith(SpringRunner::class)
@SpringBootTest(classes = [ApiApplication::class])
class NoteTest {

  @Autowired
  private lateinit var service: NoteService

  private val notes = mutableListOf<NoteDTO>()

  @Before
  fun prepare() {
    Assert.assertNotNull(service)
    // Przygotowanie 10 notatek.
    (1..10) .mapTo(notes) {
      NoteDTO(
        "Tytuł testowej notatki: $it",
        "Treść testowej notatki: $it"
      )
    }
  }

  @Test
  fun crud() {
    // Test operacji CRUD na notatkach.
    cleanup()   // Usunięcie danych z bazy przed rozpoczęciem testu.
    insert()    // Zapisanie w bazie przygotowanych wcześniej notatek.
    update()    // Modyfikacja każdej notatki.
    select()    // Sprawdzenie, czy notatki zostały zapisane.
    delete()    // Usunięcie notatek z bazy.
  }

  fun cleanup() {
    service.getNotes().forEach { note ->
      service.deleteNote(note.id)
    }
  }

  fun insert() {
    notes.forEach { note ->
      val result = service.insertNote(note)
      Assert.assertNotNull(result)
      Assert.assertNotNull(result.id)
      Assert.assertFalse(result.id.isEmpty())
      note.id = result.id
    }
  }

  fun update() {
    notes.forEach { note ->
      note.title = "Zmieniony tytuł"
      note.message = "Zmieniona treść"
      val result = service.updateNote(note)
      Assert.assertNotNull(result)
      Assert.assertNotNull(result.id)
      Assert.assertFalse(result.id.isEmpty())
      Assert.assertEquals("Zmieniony tytuł", result.title)
      Assert.assertEquals("Zmieniona treść", result.message)
    }
  }

  fun delete() {
    notes.forEach { note ->
      println("Usunięcie notatki o identyfikatorze ${note.id}")
      service.deleteNote(note.id)
    }
  }

  fun select() {
    val result = service.getNotes()
    result.forEach { note ->
      Assert.assertNotNull(note)
      Assert.assertNotNull(note.id)
      Assert.assertFalse(note.id.isEmpty())
      Assert.assertEquals("Zmieniony tytuł", note.title)
      Assert.assertEquals("Zmieniona treść", note.message)
    }
  }
}