package com.journaler.api.controller

import com.journaler.api.data.Todo
import com.journaler.api.service.TodoService
import org.springframework.http.MediaType
import org.springframework.web.bind.annotation.*
import org.springframework.beans.factory.annotation.Autowired

@RestController
@RequestMapping("/todos")
class TodoController {
  @Autowired
  private lateinit var service: TodoService

  /**
   * Pobranie zadań.
   */
  @GetMapping(
    produces = arrayOf(MediaType.APPLICATION_JSON_VALUE)
  )
  fun getTodos(): List<Todo> = service.getTodos()

  /**
   * Dodanie zadania.
   * Metoda odbiera dane, tj. treść zadania, w formacie JSON.
   */
  @PutMapping(
    produces = arrayOf(MediaType.APPLICATION_JSON_VALUE),
    consumes = arrayOf(MediaType.APPLICATION_JSON_VALUE)
  )
  fun insertTodo(
    @RequestBody todo: Todo
  ): Todo = service.insertTodo(todo)

  /**
   * Usunięcie zadania o zadanym identyfikatorze.
   * Ścieżka zawiera zmienną, której będzie przypisywany identyfikator zadania.
   */
  @DeleteMapping(
    value = "/{id}",
    produces = arrayOf(MediaType.APPLICATION_JSON_VALUE)
  )
  fun deleteTodo(
    @PathVariable(name = "id") id: String
  ): Boolean = service.deleteTodo(id)

  /**
   * Zmiana zadania.
   * Metoda odbiera dane, tj. treść zadania, w formacie JSON,
   * i zwraca wartość logiczną true po pomyślnym przetworzeniu.
   */
  @PostMapping(
    produces = arrayOf(MediaType.APPLICATION_JSON_VALUE),
    consumes = arrayOf(MediaType.APPLICATION_JSON_VALUE)
  )
  fun updateTodo(@RequestBody todo: Todo): Boolean =
    service.updateTodo(todo)
}