// Copyright © 2016 Alan A. A. Donovan & Brian W. Kernighan.
// License: https://creativecommons.org/licenses/by-nc-sa/4.0/

package tempconv

import "fmt"

func Example1() {
	{
		//!+arith
		fmt.Printf("%g\n", BoilingC-FreezingC) // "100" °C
		boilingF := CToF(BoilingC)
		fmt.Printf("%g\n", boilingF-CToF(FreezingC)) // "180" °F
		//!-arith
	}
	/*
		//!+arith
		fmt.Printf("%g\n", boilingF-FreezingC)       // błąd kompilacji: niezgodność typów
		//!-arith
	*/

	// Output:
	// 100
	// 180
}

func Example2() {
	//!+printf
	c := FToC(212.0)
	fmt.Println(c.String()) // "100°C"
	fmt.Printf("%v\n", c)   // "100°C"; nie ma potrzeby wywoływania String bezpośrednio
	fmt.Printf("%s\n", c)   // "100°C"
	fmt.Println(c)          // "100°C"
	fmt.Printf("%g\n", c)   // "100"; nie wywołuje String
	fmt.Println(float64(c)) // "100"; nie wywołuje String
	//!-printf

	// Output:
	// 100°C
	// 100°C
	// 100°C
	// 100°C
	// 100
	// 100
}
