import { AppComponent } from '../app/app.component';
import { TestBed, async } from '@angular/core/testing';

describe("tests/app.component.tests.ts ", () => {

    let appComponent;
    beforeAll( () => {
        appComponent = new AppComponent();
    });

    it("powinien utworzyć instancję AppComponent", () => {
        expect(appComponent).toBeDefined();
    });
    it('powinien ustawić tytuł', () => {
        expect(appComponent.title)
            .toContain('Select an option');
    });
    it('powinien ustawić wartość właściwości selectedItem.id', () => {
        expect(appComponent.selectedItem.id).toBe(0);
    });
    it('powinien ustawić wartość właściwości selectedItem.displayName', () => {
        expect(appComponent.selectedItem.displayName)
            .toBe('none');
    });
});

describe('AppComponent rendering tests', () => {
  beforeEach(() => {
    TestBed.configureTestingModule({
      declarations: [
        AppComponent
      ],
    });
    TestBed.compileComponents();
  });

    it('powinien wyświetlać w DOM 0 - none', async(() => {
        const fixture = TestBed.createComponent(AppComponent);
        fixture.detectChanges();
        const element = fixture.debugElement.nativeElement;
        let selectedDiv = element.querySelector('#selectedItemText');
        expect(selectedDiv.innerHTML).toContain('0 - none');
    }));

it('powinien zaktualizować DOM po kliknięciu przycisku', async(() => {
    const fixture = TestBed.createComponent(AppComponent);
    fixture.detectChanges();
    const element = fixture.debugElement.nativeElement;
    let button_1 = element.querySelector('#select_button_0');
    button_1.click();

    fixture.detectChanges();

    let selectedDiv = element.querySelector('#selectedItemText');
    expect(selectedDiv.innerHTML).toContain('firstItem');
}));

});
