module.exports = {

  entry : {
    app: "./app/index.tsx",
    test: "./test/react.app.tests.tsx",
    e2e: "./test/e2e/react.app.e2e.tests.tsx"
  },

  output: {
    filename: "./dist/[name].js",
  },

  // Enable sourcemaps for debugging webpack's output.
  devtool: "source-map",

  resolve: {
    // Add '.ts' and '.tsx' as resolvable extensions.
    extensions: ["", ".webpack.js", 
      ".web.js", ".ts", ".tsx", ".js"]
  },

  module: {
    loaders: [
      // All files with a '.ts' or '.tsx' extension 
      // will be handled by 'ts-loader'.
      { test: /\.tsx?$/, 
        loader: "ts-loader" }
    ],

    preLoaders: [
      // All output '.js' files will have any 
      // sourcemaps re-processed by 'source-map-loader'.
      { test: /\.js$/, 
        loader: "source-map-loader" }
    ]
  },

  externals: {
    "react": "React",
    "react-dom": "ReactDOM"
  },
};
