import * as React from "react";
import * as ReactDOM from "react-dom";
import * as TestUtils from "react-addons-test-utils";
import {ArrayView, ClickableItem} from '../app/ReactApp';

describe('testy modelu ArrayView', () => {
  it('powinien utworzyć nową instancję ArrayView', () => {
    var app = new ArrayView();
    expect(app).toBeDefined();
    expect(app.selectedItem.id).toBe(0);
    expect(app.selectedItem.displayName).toBe('none');
  });
});

describe('testy ArrayView', () => {
  let renderer : any;

  let ClickableItemArray : ClickableItem[] = [
    { id: 1, displayName : "pierwszyElement"},
    { id: 2, displayName : "drugiElement"},
    { id: 3, displayName : "trzeciElement"},
  ]; 

  beforeEach( () => {
    renderer = TestUtils.renderIntoDocument(
      <ArrayView items={ClickableItemArray} title="Wybierz opcję:"  />);
  });

  it('powinien wyświetlić informację o braku wybranego elementu', () => {

    let domNode = ReactDOM.findDOMNode(renderer);
    let selectedItem = domNode.querySelector('#selectedItem');
    expect(selectedItem.textContent).toBe('Wybrany element: 0 - none');

  });

  it('powinien znaleźć przycisk select_button_1', () => {

    let domNode = ReactDOM.findDOMNode(renderer);

    let button_1 = domNode.querySelector('#select_button_1');
    expect(button_1).toBeDefined();
    expect(button_1.innerHTML).toBe('pierwszyElement');

  });

  it('kliknięcie przycisku select_button_1 powinno zaktualizować DOM', () => {

    let domNode = ReactDOM.findDOMNode(renderer);

    let button_1 = domNode.querySelector('#select_button_1');
    TestUtils.Simulate.click(button_1);
    
    let selectedItem = domNode.querySelector('#selectedItem');
    expect(selectedItem.textContent).toContain('1 - pierwszyElement');

  });
});