describe("tests/01_SimpleJasmineTests.ts ", () => {

  it("po przypisaniu wartość zmiennej ma być zdefiniowana", () => {
    let undefinedValue = "test";
    expect(undefinedValue).toBeDefined();
  });

  it("oczekujemy, że wartość nie będzie zdefiniowana", () => {
    var undefinedValue;
    expect(undefinedValue).not.toBeDefined();
  });

  it("warość ma być równa 2", () => {
    let twoValue = 2;
    expect(twoValue).toBe(2);
  })

  it("łańcuch ma zawierać fragment", () => {
    let testString = "12345a";
    expect(testString).toContain("a");
  });

  it("oczekujemy logicznej prawdy", () => {
    let trueValue = true;
    expect(trueValue).toBeTruthy();
  });

  it("oczekujemy, że false nie będzie logiczną prawdą", () => {
    let falseValue = false;
    expect(falseValue).not.toBeTruthy();
  });

  it("oczekujemy, że wartość będzie różna od null", () => {
    let definedValue = 2;
    expect(definedValue).not.toBe(null);
  });

  it("oczekujemy, że obiekty będą sobie równe", () => {
      let obj1 = {a : 1, b : 2};
      let obj2 = {b : 2, a : 1};

      expect(obj1).toEqual(obj2);
  });

  describe("testy z funkcjami beforEach oraz afterEach", () => {
    let myString;
    beforeEach( () => {
      myString = "to jest łańcuch";
    });
    afterEach( () => {
      expect(myString).toBeUndefined();
    });
    it("powinien ustawić, a potem wyczyścić wartość zmiennej myString", () => {
      expect(myString).toEqual("to jest łańcuch");
      myString = undefined;
    });
  });

  describe("test bazujący na danych", () => {
    using("prawidłowe wartości", [
      "pierszy łańcuch",
      "drugi łańcuch",
      "trzeci łańcuch"
    ], (value) => {
      it(`Łańcuch '${value}' powinien zawierać fragment 'łańcuch'`, () => {
        expect(value).toContain("łańcuch");
      });
    });
  });

  class MySpiedClass {
    testFunction(arg1: string) {
      console.log(arg1);
    }
  }
  describe("prosty szpieg", () => {
    it("ma szpiegować wywołanie funkcji", () => {
      let classInstance = new MySpiedClass();
      let testFunctionSpy 
        = spyOn(classInstance, 'testFunction');
    
      classInstance.testFunction("test");
      
      expect(testFunctionSpy).toHaveBeenCalled();
    });
  });



  class CallbackClass {
    doCallBack(id: number, callback: (result: string) => void ) {
      let callbackValue = "id:" + id.toString();
      callback(callbackValue);
    }
  }

  class DoCallBack {
    logValue(value: string) {
      console.log(value);
    }
  }

  describe("szpiegowanie funkcji zwrotnych", () => {
    it("powinien wywołać funkcję zwrotną i przekazać do niej odpowiedni łańcuch znaków", 
      () => {
      let doCallback = new DoCallBack();
      let classUnderTest = new CallbackClass();

      let callbackSpy = spyOn(doCallback, 'logValue');
      classUnderTest.doCallBack(1, doCallback.logValue);

      expect(callbackSpy).toHaveBeenCalled();
      expect(callbackSpy).toHaveBeenCalledWith("id:1");

    });
  });


  class ClassToFake {
    getValue() : number {
      return 2;
    }
  }
  describe("stosowanie atrap", () => {
    it("wywołuje atrapę zamiast rzeczywistej funkcji", () => {
      let classToFake = new ClassToFake();
      spyOn(classToFake, 'getValue').and.callFake ( () => {
        return 5;
      });
      expect(classToFake.getValue()).toBe(5);
    });
  });


  class MockAsyncClass {
    executeSlowFunction(success: (value: string) => void) {
      setTimeout(() => {
        success("sukces");
      }, 1000);
    }
  }

  /*
  describe("testy asynchroniczne", () => {
    it("test zakończony niepowodzeniem", () => {
      var mockAsync = new MockAsyncClass();
      var returnedValue : string;
      mockAsync.executeSlowFunction((value: string) => {
          returnedValue = value;
      });
      expect(returnedValue).toEqual("sukces");
    });
  });
  */

  describe("test asynchroniczny z użyciem funkcji done", () => {
    let returnedValue;

    beforeEach((done) => {
      returnedValue = "no_return_value";
      let mockAsync = new MockAsyncClass();
      mockAsync.executeSlowFunction((value: string) => {
        returnedValue = value;
        done();
      });
    });

    it("powinien zakończyć się sukcesem po 1 sekundzie", (done) => {
      expect(returnedValue).toEqual("sukces");
      done();
    });
  });


  class ModifyDomElement {
    setHtml() {
      let elem = $('#my_div');
      elem.html('<p>Witaj, świecie</p>');
    }
  }

  describe("test funkcji setFixture", () => {
    it("powinien zmodyfikować zawartość elementu DOM", () => {
      setFixtures('<div id="my_div"></div>');
      let modifyDom = new ModifyDomElement();
      modifyDom.setHtml();
      let modifiedDomElement = $('#my_div');
      expect(modifiedDomElement.length).toBeGreaterThan(0);
      expect(modifiedDomElement.html()).toContain("Witaj");
    });
  });

  describe("testy kliknięcia", () => {
    it("powinien wywołać zdarzenie onclick DOM", () =>{
      setFixtures(`
        <script>
        function handle_my_click_div_clicked() { 
          // tu można coś zrobić po kliknięciu
        }
        </script>        
        <div id='my_click_div'
        onclick='handle_my_click_div_clicked()'>Proszę kliknąć!</div>`);
      let clickEventSpy = spyOnEvent('#my_click_div', 'click');
      $('#my_click_div').click();
      expect(clickEventSpy).toHaveBeenTriggered();
    });
  });


});
