describe('Testy modelu ItemModel', () => {
  let itemModel : ItemModel;
  beforeEach( () => {
    itemModel = new ItemModel(
      {Id : 1, DisplayName : 'testDisplay'}
    );
  });
  it('powinna zostać ustawiona właściwość Id', () => {
    expect(itemModel.Id).toBe(1);
  });
  it('powinna zostać ustawiona właściwość DisplayName', () => {
    expect(itemModel.DisplayName).toBe('testDisplay');
  });
  it('powinna zostać ustawiona właściwość Id', () => {
    itemModel.Id = -10;
    expect(itemModel.Id).toBe(-10);
  });
  it('powinna zostać ustawiona właściwość DisplayName', () => {
    itemModel.DisplayName = 'updatedDisplay';
    expect(itemModel.DisplayName).toBe('updatedDisplay');
  });
  it('powinna zostać wywołania funkcja set właściwości Id', () => {
    itemModel.set('Id', -10);
    expect(itemModel.get('Id')).toBe(-10);
  });
  it('powinna zostać wywołania funkcja set właściwości DisplayName', () => {
    itemModel.set('DisplayName', 'updatedDisplay');
    expect(itemModel.get('DisplayName')).toBe('updatedDisplay');
  });
});

describe('Testy modelu ItemCollectionViewModel', () => {
  let itemCollectionViewModel : ItemCollectionViewModel;
  beforeAll( () => {
    itemCollectionViewModel = new ItemCollectionViewModel(
      { Title : 'testTitle',
        SelectedItem : { Id : 0, DisplayName : 'testDisplay'}
      }
    );
  });
  it('powinna zostać ustawiona właściwość Title', () => {
    expect(itemCollectionViewModel.Title).toBe('testTitle');
  });
  it('powinna zostać ustawiona właściwość SelectedItem.Id', () => {
      expect(itemCollectionViewModel.SelectedItem.Id).toBe(0);
  });
  it('powinna zostać ustawiona właściwość SelectedItem.DisplayName', () => {
      expect(itemCollectionViewModel.SelectedItem.DisplayName)
      .toBe('testDisplay');
  });

});

describe('Testy wyświetlania widokuk ItemView', () => {
  let itemModel : ItemModel;
  beforeEach( () => {
    
    setFixtures(
      `<div id="itemViewElement"></div>
    
      <script type="text/template" id="itemViewTemplate">
        <button id='itemButton'> <%= DisplayName %> </button>
      </script>
    
      <script type="text/template" id="itemCollectionViewTemplate">
      </script>
    `);

    itemModel = new ItemModel({Id : 1, DisplayName : 'nazwaTestowa'});
  });

// afterEach( () => {
// <li>
//     <button id="itemButton">nazwaTestowa</button> 
// </li>
    

  // });
  it('powinnne zostać wygenerowane elementy li oraz button', () => {
    let itemView = new ItemView({model : itemModel});
    let renderedHtml = itemView.render().el;
    console.log(renderedHtml.outerHTML);
    expect(renderedHtml.outerHTML).toContain('<li>');
    expect(renderedHtml.innerHTML).toContain('<button id="itemButton">');
    expect(renderedHtml.innerHTML).toContain('nazwaTestowa')
  });

  it('powinna zostać wywołana funkcja onClicked', () => {
    
    let clickSpy = spyOn(ItemView.prototype, 'onClicked');
    // trzeba dodać szpiega do prototypu, jeszcze przed utworzeniem modelu.
    let itemView = new ItemView({model : itemModel});
    
    itemView.render();
    itemView.$('#itemButton').trigger("click");

    expect(clickSpy).toHaveBeenCalled();

  });

  it('powinien nasłuchiwać zdarzeń kliknięcia w widoku ItemCollectionView', () => {
    let clickSpy = spyOn(ItemCollectionView.prototype, 'handleEvent');
    let itemCollectionView = new ItemCollectionView();

    let itemView = new ItemView({model : itemModel});
    itemView.render();

    itemView.$('#itemButton').trigger("click");

    expect(clickSpy).toHaveBeenCalled();

  });
});
