﻿using System;
using Dzien05.Lib;
using static System.Console;
using static System.Convert;

namespace Dzien05
{
    internal class Program
    {
        private static PrintFizzBuzz _printFizzBuzz;

        private static void Main(string[] args)
        {
            int userInput;
            do
            {
                userInput = DisplayMenu();
                switch (userInput)
                {
                    case 1:
                        Clear();
                        Write("Wpisz liczbę: ");
                        var number = ReadLine();
                        var objectOddEven = new OddEven();
                        var result = objectOddEven.PrintSingleOddEven(ToInt32(number));
                        WriteLine($"Liczba {number} jest {result}.");
                        PressAnyKey();
                        break;
                    case 2:
                        Clear();
                        Write("Wpisz liczbę: ");
                        var num = ReadLine();
                        var objInstance = Activator.CreateInstance(typeof(OddEven));
                        var method = typeof(OddEven).GetMethod("PrintSingleOddEven");
                        var res = method.Invoke(objInstance, new object[] { ToInt32(num) });
                        WriteLine($"Liczba {num} jest {res}.");

                        PressAnyKey();  
                        break;
                    case 3:
                        Clear();
                        WriteLine("Pobieranie informacji na temat typu 'Dzien05.Program' przy użyciu operatora 'typeof'.");
                        var typeInfo = typeof(Program);
                        typeInfo.GetConstructor(new[] { typeof(Program) });
                        WriteLine();
                        WriteLine("Analiza wyników:");
                        WriteLine("=========================");
                        WriteLine($"Zestaw:{typeInfo.AssemblyQualifiedName}");
                        WriteLine($"Nazwa:{typeInfo.Name}");
                        WriteLine($"Pełna nazwa:{typeInfo.FullName}");
                        WriteLine($"Przestrzeń nazw:{typeInfo.Namespace}");
                        WriteLine("=========================");
                        PressAnyKey();
                        break;
                    case 4:
                        Clear();
                        WriteLine("Pobieranie informacji na temat typu 'Dzien05.Program' przy użyciu metody 'GetType()'.");
                        var info = Type.GetType("Dzien05.Program");
                        WriteLine();
                        WriteLine("Analiza wyników:");
                        WriteLine("=========================");
                        WriteLine($"Zestaw:{info.AssemblyQualifiedName}");
                        WriteLine($"Nazwa:{info.Name}");
                        WriteLine($"Pełna nazwa:{info.FullName}");
                        WriteLine($"Przestrzeń nazw:{info.Namespace}");
                        WriteLine("=========================");
                        PressAnyKey();
                        break;
                    case 5:
                        Clear();
                        WriteLine("Pobieranie informacji przy użyciu klasy System.Reflection.Extensins.");
                        var information = typeof(OddEven);
                        var cons = information.GetConstructor(new[] { information });
                        WriteLine();
                        WriteLine("Analiza wyników:");
                        WriteLine("=========================");
                        WriteLine($"Zestaw:{information.AssemblyQualifiedName}");
                        WriteLine($"Nazwa:{information.Name}");
                        WriteLine($"Pełna nazwa:{information.FullName}");
                        WriteLine($"Przestrzeń nazw:{information.Namespace}");
                        WriteLine($"Przestrzeń nazw:{information.GetConstructor(new[] { information })}");
                        WriteLine("=========================");
                        PressAnyKey();
                        break;
                    case 6:
                        Clear();
                        WriteLine(" ");
                        Write("Wpisz liczbę: ");
                        var inputNum = ReadLine();
                        _printFizzBuzz = FizzBuzz.PrintFizzBuzz;
                        var fizzBuzImpl = new FizzBuzzImpl();
                        WriteLine("Zastosowanie delegacji:");
                        WriteLine($"Wpisana liczba, {inputNum}, jest {_printFizzBuzz(ToInt32(inputNum))}");
                        WriteLine();
                        WriteLine("Zastosowanie zdarzenia:");
                        WriteLine($"Wpisana liczba, {inputNum}, jest {fizzBuzImpl.EventImplementation(ToInt32(inputNum))}");
                        PressAnyKey();
                        break;
                    case 7:
                        Clear();
                        Write("Podaj wielkość kolekcji ArrayList: ");
                        var inputSize = ReadLine();
                        var arrayListExample = new CollectionGeneric();
                        arrayListExample.ArrayListExample(ToInt32(inputSize));
                        PressAnyKey();
                        break;
                    case 8:
                        Clear();
                        new CollectionGeneric().HashTableExample();
                        PressAnyKey();
                        break;
                    case 9:
                        Clear();
                        new CollectionGeneric().SortedListExample();
                        PressAnyKey();
                        break;
                    case 10:
                        Clear();
                        new CollectionGeneric().StackExample();
                        PressAnyKey();
                        break;
                    case 11:
                        Clear();
                        new CollectionGeneric().QueueExample();
                        PressAnyKey();
                        break;
                }
            } while (userInput != 12);
        }

        private static void PressAnyKey()
        {
            WriteLine("Naciśnij dowolny klawisz...");
            ReadLine();
            Clear();
        }

        private static int DisplayMenu()
        {
            return ToInt32(SelectedMenu());
        }

        private static int SelectedMenu()
        {
            WriteLine("Nauka C# w 7 dni - Przykłady - Dzień 5.");
            WriteLine();
            WriteLine("1. Określanie parzystości bez użycia odzwierciedlania.");
            WriteLine("2. Określanie parzystości z użyciem odzwierciedlania.");
            WriteLine("3. Prezentacja możliwości klasy System.Type class - zastosowanie typeof.");
            WriteLine("4. Prezentacja możliwości klasy System.Type class - zastosowanie GetType().");
            WriteLine("5. Pobieranie kompletnych informacji przy użyciu klasy System.Reflection.Extensins.");
            WriteLine("6. Przykład delegacji i zdarzeń.");
            WriteLine("7. Przykład zastosowania klasy ArrayList.");
            WriteLine("8. Przykład zastosowania klasy Hashtable.");
            WriteLine("9. Przykład zastosowania klasy SortedList.");
            WriteLine("10. Przykład zastosowania klasy Stack.");
            WriteLine("11. Przykład zastosowania klasy Queue.");
            WriteLine("12. Koniec");
            Write("Wybierz opcję (1-11): ");
            var result = ReadLine();
            return string.IsNullOrEmpty(result) ? 0 : ToInt32(result);
        }

        private delegate string PrintFizzBuzz(int number);
    }
}
