﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using System.Security.Cryptography.X509Certificates;

namespace Dzien04
{
    #region Przykład: Modyfikator protected internal

    //internal class StringCalculator
    //{
    //    protected internal string Num1 { get; set; }
    //    protected internal string Num2 { get; set; }
    //}

    //internal class StringCalculatorImplement : StringCalculator
    //{
    //    public int Sum()
    //    {
    //        return Convert.ToInt32(Num1) + Convert.ToInt32(Num2);
    //    }
    //}

    #endregion

    #region Przykład: Modyfikator private

    //internal class StringCalculator
    //{
    //    private string Num1 { get; set; }
    //    private string Num2 { get; set; }

    //    public int Sum() => Convert.ToInt32(Num1) + Convert.ToInt32(Num2);

    //    public int Add(int num1, int num2)
    //    {
    //        if (num1 > 100 || num2 > 100)
    //            num1 = num2=100;

    //        return num1 + num2;
    //    }
    //}

    //internal class StringCalculatorAnother
    //{
    //    private readonly StringCalculator _calculator;

    //    public StringCalculatorAnother(StringCalculator calculator)
    //    {
    //        _calculator = calculator;
    //    }

    //    //public int Sum()
    //    //{
    //    //    return Convert.ToInt32(_calculator.Num1) + Convert.ToInt32(_calculator.Num2);
    //    //}
    //}

    #endregion

    #region Przykład: Modyfikator abstract 

    //internal abstract class StringCalculator
    //{
    //    public  string Num1 { get; set; }
    //    public  string Num2 { get; set; }
    //    public abstract int Sum();

    //}

    //internal class StringCalculatorImplement : StringCalculator
    //{
    //    public override int Sum() => Convert.ToInt32(Num1) + Convert.ToInt32(Num2);
    //}

    #endregion

    #region Przykład: Modyfikator async 

    //internal class StringCalculator
    //{
    //    public string Num1 { get; set; }
    //    public string Num2 { get; set; }
    //    public async Task<int> Sum()
    //    {
    //        return await Task.Run(()=>Convert.ToInt32(Num1) + Convert.ToInt32(Num2));
    //    }
    //}

    #endregion

    #region Przykład: Modyfikator const 

    //internal class StringCalculator
    //{
    //    private const int Num1 = 70;
    //    public const double Pi = 3.14;
    //    public const string Book = "Nauka C# w 7 dni";

    //    public int Sum()
    //    {
    //        const int num2 = Num1 + 85;

    //        return  Convert.ToInt32(Num1) + Convert.ToInt32(num2);
    //    }
    //}

    #endregion

    #region Przykład: Modyfikator new 

    //internal class StringCalculator
    //{
    //    private const int Num1 = 70;
    //    private const int Num2 = 89;

    //    public int Sum() => Num1 + Num2;
    //}

    //internal class StringCalculatorImplement : StringCalculator
    //{
    //    public int Num1 { get; set; }
    //    public int Num2 { get; set; }

    //    public new int Sum() => Num1 + Num2;
    //}

    #endregion

    #region Przykład: Modyfikator virtual 

    //internal class StringCalculator
    //{
    //    private const int Num1 = 70;
    //    private const int Num2 = 89;

    //    public virtual int Sum() => Num1 + Num2;
    //}

    //internal class StringCalculatorImplement : StringCalculator
    //{
    //    public int Num1 { get; set; }
    //    public int Num2 { get; set; }

    //    public override int Sum() => Num1 + Num2;
    //}

    #endregion

    #region Przykład: Modyfikator readonly 

    //internal class StringCalculator
    //{
    //    private readonly int _num2;
    //    public readonly int Num1 = 179;

    //    public StringCalculator(int num2)
    //    {
    //        _num2 = num2;
    //    }

    //    public int Sum()
    //    {
    //        return Num1 + _num2;
    //    }
    //}

    #endregion

    #region Przykład: Modyfikator sealed 

    //internal abstract class StringCalculator
    //{
    //    public int Num1 { get; set; }
    //    public int Num2 { get; set; }

    //    public abstract int Sum();
    //    public virtual int Sub() => Num1 -Num2;
    //}

    //internal class Calc : StringCalculator
    //{
    //    public int Num3 { get; set; }
    //    public int Num4 { get; set; }
    //    public override int Sub() => Num3 - Num4;

    //    //This will not be inherited from within derive classes
    //    //any more
    //    public sealed override int Sum() => Num3 + Num4;
    //}

    //internal sealed class SealedCalc : Calc
    //{
    //    public override int Sub() => Num1 - Num2;

    //}

    #endregion

    #region Przykład: Modyfikator static 

    //internal static class StringCalculator
    //{
    //    public const int Num1 = 10;
    //    public const int Num2 = 20;
    //    public int I { private get; set; }

    //    public static int Sum() => Num1 + Num2;
    //    //public int Sub() => Num1 - Num2;
    //}

    #endregion

    #region Przykład: Właściwości

    internal class PropertyExample: INotifyPropertyChanged
    {
        private int _number;

        public PropertyExample(int num1)
        {
            Num1 = num1;
        }
        // właściwość ustawiania w konstruktorze
        public int Num1 { get; }
        // automatyczna właściwość tylko do odczytu
        public int Num2 { get; private set; }
        // właściwość tylko do odczytu zainicjowana jako kolekcja
        public IEnumerable<string> Numbers { get; } = new List<string>();

        public int Num3 { get; set; }
        public int Num4 { get; set; }

        public int Add => Num3 + Num4;

        public int Sum {
            get
            {
                return Num3 + Num4;
            }
        }

        public int Number
        {
            get => _number;
            set
            {
                if (value < 0)
                {
                    // rejestracja komunikatu lub wykonanie akcji
                    // Log("Liczba jest mniejsza od zera.");
                    throw new ArgumentException("Liczba nie może być ujemna.");
                }
                _number = value;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected virtual void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }

    #endregion

    #region Obsługa wyjątków

    class ExceptionhandlingExample
    {
        public int Div(int dividend,int divisor)
        {
            int quotient = 0;
            try
            {
                quotient = dividend / divisor;

            }
            catch (Exception exception)
            {
                Console.WriteLine($"Zgłoszono wyjątek '{exception.Message}'");

            }
            finally
            {
                Console.WriteLine("Wyjątek został przechwycony i obsłużony.");
            }

            return quotient;
        }
    }

    #endregion
}