﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Dzien03Lib
{
    public class PatternMatching
    {
        private static IEnumerable<char> Vowels => new[] {'a', 'e', 'i', 'o', 'u', 'ą', 'ę', 'ó', 'y'};

        public static string MatchingPatternUsingIs(object character)
        {
            if (character is null)
                return $"Zmienna {nameof(character)} jest równa null. ";
            if (character is char)
                return $"{character} jest znakiem i {VowelOrConsonent((char) character)}.";
            if (character is string str)
            {
                var chars = str.ToArray();
                var stringBuilder = new StringBuilder();
                foreach (var c in chars)
                    if (!char.IsWhiteSpace(c))
                    {
                        var isVowel = VowelOrConsonent(c);
                        stringBuilder.AppendLine($"{c} jest znakiem łańcucha '{character}' i {isVowel}.");
                    }

                return stringBuilder.ToString();
            }

            if (character is int number)
                return $"Zmienna {nameof(character)} jest typu int i ma wartość {number}.";
            throw new ArgumentException(
                "Nie rozpoznano typu zmiennej character.",
                nameof(character));
        }

        public static string ConstantPatternUsingSwitch(params char[] inputChar)
        {
            switch (inputChar.Length)
            {
                case 0:
                    return $"Zmienna {nameof(inputChar)} nie zawiera żadnych elementów.";
                case 1:
                    return $"Znak '{inputChar[0]}', który {VowelOrConsonent(inputChar[0])}.";
                case 2:
                    var sb = new StringBuilder().AppendLine($"Znak '{inputChar[0]}', który {VowelOrConsonent(inputChar[0])}.");
                    sb.AppendLine($"Znak '{inputChar[1]}', który {VowelOrConsonent(inputChar[1])}.");
                    return sb.ToString();
                case 3:
                    var sb1 = new StringBuilder().AppendLine($"Znak '{inputChar[0]}', który {VowelOrConsonent(inputChar[0])}.");
                    sb1.AppendLine($"Znak '{inputChar[1]}', który {VowelOrConsonent(inputChar[1])}.");
                    sb1.AppendLine($"Znak '{inputChar[2]}', który {VowelOrConsonent(inputChar[2])}.");
                    return sb1.ToString();
                case 4:
                    var sb2 = new StringBuilder().AppendLine($"Znak '{inputChar[0]}', który {VowelOrConsonent(inputChar[0])}.");
                    sb2.AppendLine($"Znak '{inputChar[1]}', który {VowelOrConsonent(inputChar[1])}.");
                    sb2.AppendLine($"Znak '{inputChar[2]}', który {VowelOrConsonent(inputChar[2])}.");
                    sb2.AppendLine($"Znak '{inputChar[3]}', który {VowelOrConsonent(inputChar[3])}.");
                    return sb2.ToString();
                case 5:
                    var sb3 = new StringBuilder().AppendLine($"Znak '{inputChar[0]}', który {VowelOrConsonent(inputChar[0])}.");
                    sb3.AppendLine($"Znak '{inputChar[1]}', który {VowelOrConsonent(inputChar[1])}.");
                    sb3.AppendLine($"Znak '{inputChar[2]}', który {VowelOrConsonent(inputChar[2])}.");
                    sb3.AppendLine($"Znak '{inputChar[3]}', który {VowelOrConsonent(inputChar[3])}.");
                    sb3.AppendLine($"Znak '{inputChar[4]}', który {VowelOrConsonent(inputChar[4])}.");
                    return sb3.ToString();
                default:
                    return $"{inputChar.Length} przekracza dopuszczalną długość łańcucha.";
            }
        }

        public static string TypePatternUsingSwitch(IEnumerable<object> inputObjects)
        {
            var message = new StringBuilder();
            foreach (var inputObject in inputObjects)
                switch (inputObject)
                {
                    case char c:
                        message.AppendLine($"'{c}' jest znakiem i {VowelOrConsonent(c)}.");
                        break;
                    case IEnumerable<object> listObjects:
                        foreach (var listObject in listObjects)
                            message.AppendLine(MatchingPatternUsingIs(listObject));
                        break;
                    case null:
                        break;
                }
            return message.ToString();
        }

        public static string TypePatternWhenInCaseUsingSwitch(IEnumerable<object> inputObjects)
        {
            var message = new StringBuilder();
            foreach (var inputObject in inputObjects)
                switch (inputObject)
                {
                    case char c:
                        message.AppendLine($"'{c}' jest znakiem i {VowelOrConsonent(c)}.");
                        break;
                    case IEnumerable<object> listObjects when listObjects.Any():
                        foreach (var listObject in listObjects)
                            message.AppendLine(MatchingPatternUsingIs(listObject));
                        break;
                    case IEnumerable<object> listInlist:
                        break;
                    case null:
                        break;
                }
            return message.ToString();
        }

        private static string VowelOrConsonent(char c)
        {
            return IsVowel(c) ? "jest samogłoską" : "jest spółgłoską";
        }

        private static bool IsVowel(char character) => Vowels.Contains(char.ToLower(character));
        
    }
}