﻿using System;
using System.Collections.Generic;
using System.Linq;
using static System.Console;
using static System.Convert;

namespace Dzien02
{
    internal class Program
    {
        private static void Main(string[] args)
        {

            int userInput;
            do
            {
                userInput = DisplayMenu();
                switch (userInput)
                {
                    case 1:
                        Clear();
                        SameClassDifferentNamespacesExample();
                        PressAnyKey();
                        break;
                    case 2:
                        Clear();
                        ConsoleOperationExamples();
                        PressAnyKey();
                        break;
                    case 3:
                        Clear();
                        ConsoleBeepExample();
                        PressAnyKey();
                        break;
                    case 4:
                        Clear();
                        ExampleIsAsOperator();
                        PressAnyKey();
                        break;
                    case 5:
                        Clear();
                        CheckOverFlowExample();
                        PressAnyKey();
                        break;
                    case 6:
                        Clear();
                        SizeofExample();
                        PressAnyKey();
                        break;
                    case 7:
                        Clear();
                        TypeofExample();
                        PressAnyKey();
                        break;
                    case 8:
                        Clear();
                        UsingExample();
                        PressAnyKey();
                        break;
                    case 9:
                        Clear();
                        DynamicTypeExample();
                        PressAnyKey();
                        break;
                    case 10:
                        Clear();
                        DataTypeExample();
                        PressAnyKey();
                        break;
                    case 11:
                        Clear();
                        BoxingUnboxingExample();
                        PressAnyKey();
                        break;
                    case 12:
                        Clear();
                        OperatorExample();
                        PressAnyKey();
                        break;
                    case 13:
                        Clear();
                        OperatorOverloadingExample();
                        PressAnyKey();
                        break;
                    case 14:
                        Clear();
                        ImplicitExplicitTypeConversionExample();
                        PressAnyKey();
                        break;
                    case 15:
                        Clear();
                        StatementExample();
                        PressAnyKey();
                        break;
                    case 16:
                        Clear();
                        IfStatementExample();
                        PressAnyKey();
                        break;
                    case 17:
                        Clear();
                        IfElseStatementExample();
                        PressAnyKey();
                        break;
                    case 18:
                        Clear();
                        IfElseIfElseStatementExample();
                        PressAnyKey();
                        break;
                    case 19:
                        Clear();
                        NestedIfStatementExample();
                        PressAnyKey();
                        break;
                    case 20:
                        Clear();
                        SwitchCaseExample();
                        PressAnyKey();
                        break;
                    case 21:
                        Clear();
                        DoWhileStatementExample();
                        PressAnyKey();
                        break;
                    case 22:
                        Clear();
                        WhileStatementExample();
                        PressAnyKey();
                        break;
                    case 23:
                        Clear();
                        ForStatementExample();
                        PressAnyKey();
                        break;
                    case 24:
                        Clear();
                        ForEachStatementExample();
                        PressAnyKey();
                        break;
                    case 25:
                        Clear();
                        BreakStatementExample();
                        PressAnyKey();
                        break;
                    case 26:
                        Clear();
                        ContinueStatementExample();
                        PressAnyKey();
                        break;
                    case 27:
                        Clear();
                        ArrayExample();
                        PressAnyKey();
                        break;
                    case 28:
                        Clear();
                        StringExample();
                        PressAnyKey();
                        break;
                    case 29:
                        Clear();
                        StructureExample();
                        PressAnyKey();
                        break;
                    case 30:
                        Clear();
                        ClassExample();
                        PressAnyKey();
                        break;
                }
            } while (userInput != 31);


        }
        private static void PressAnyKey()
        {
            Write("\nNaciśnij dowolny klawisz...");
            ReadLine();
            Clear();
        }

        private static int DisplayMenu()
        {
            return ToInt32(SelectedMenu());
        }

        private static int SelectedMenu()
        {
            WriteLine("Nauka C# w 7 dni - Przykłady - Dzień 2.");
            WriteLine();
            WriteLine("1. Ta sama klasa w różnych przestrzeniach nazw.");
            WriteLine("2. Przykłady operacji konsolowych.");
            WriteLine("3. Dźwięk w aplikacji konsolowej.");
            WriteLine("4. Przykład operatora as.");
            WriteLine("5. Przykład sprawdzania przepełnienia.");
            WriteLine("6. Przykład zastosowania operatora sizeof.");
            WriteLine("7. Przykład zastosowania operatora typeof");
            WriteLine("8. Przykład użycia using.");
            WriteLine("9. Przykład dynamicznego określania typów.");
            WriteLine("10. Typy danych.");
            WriteLine("11. Przykład pakowania i rozpakowywania.");
            WriteLine("12. Operatory.");
            WriteLine("13. Przykład przeciążania operatorów.");
            WriteLine("14. Przykład niejawnej i jawnej konwersji typów.");
            WriteLine("15. Przykłady instrukcji.");
            WriteLine("16. Przykład instrukcji if.");
            WriteLine("17. Przykład instrukcji if-else.");
            WriteLine("18. Przykład instrukcji if-else-if-else.");
            WriteLine("19. Przykład zagnieżdżania instrukcji if.");
            WriteLine("20. Przykład instrukcji switch-case.");
            WriteLine("21. Przykład instrukcji do-while.");
            WriteLine("22. Przykład instrukcji while.");
            WriteLine("23. Przykład instrukcji for.");
            WriteLine("24. Przykład instrukcji foreach.");
            WriteLine("25. Przykład instrukcji break.");
            WriteLine("26. Przykład instrukcji constinue.");
            WriteLine("27. Przykłady tablic.");
            WriteLine("28. Przykłady łańcuchów znaków.");
            WriteLine("29. Przykłady struktur.");
            WriteLine("30. Przykłady klas.");
            WriteLine("31. Koniec");
            Write("Wybierz opcję menu (1-30): ");
            var result = ReadLine();
            return string.IsNullOrEmpty(result) ? 0 : ToInt32(result);
        }

        private static void StructureExample()
        {
            WriteLine("Przykłady struktur\n");
            Write("Imię autora:");
            var name = ReadLine();
            Write("Tytuł książki:");
            var bookTitle = ReadLine();
            Write("Wiek autora:");
            var age = ReadLine();
            Write("Miasto:");
            var city = ReadLine();
            Write("Stan:");
            var state = ReadLine();
            Write("Kraj:");
            var country = ReadLine();

            BookAuthor author = new BookAuthor(name, bookTitle, Convert.ToInt32(age), city, state, country);
            WriteLine($"{author.ToString()}");
            BookAuthor author1 = author; // kopiowanie struktury; to nie jest klasa, więc operacja ta
                                         // spowoduje skopiowanie danych
            Write("Zmień imię autora:");
            var name1 = ReadLine();
            author.Name = name1;

            WriteLine("Autor 1.");
            WriteLine($"{author.ToString()}");
            WriteLine("Autor 2.");
            WriteLine($"{author1.ToString()}");
        }

        private static void ClassExample()
        {
            WriteLine("Przykłady klas\n");
            Write("Imię autora:");
            var name = ReadLine();
            Write("Tytuł książki:");
            var bookTitle = ReadLine();
            Write("Wiek autora:");
            var age = ReadLine();
            Write("Miasto:");
            var city = ReadLine();
            Write("Stan:");
            var state = ReadLine();
            Write("Kraj:");
            var country = ReadLine();

            ClassBookAuthor author = new ClassBookAuthor(name, bookTitle, Convert.ToInt32(age), city, state, country);
            WriteLine($"{author.ToString()}");
            ClassBookAuthor author1 = author; // kopiowanie klasy; spowoduje skopiowanie referencji

            Write("Zmień imię autora:");
            var name1 = ReadLine();
            author.Name = name1;

            WriteLine("Autor 1.");
            WriteLine($"{author.ToString()}");
            WriteLine("Autor 2.");
            WriteLine($"{author1.ToString()}");
        }


        private static void StringExample()
        {
            WriteLine("Tworzenie obiektu String");
            string authorName = "Gustaw Florek"; // przypisanie literału łańcuchowego
            WriteLine($"{authorName}");
            string property = "Imię: ";
            string person = "Gustaw";
            string personName = property + person; // konkatenacja łańcuchów znaków
            WriteLine($"{personName}");

            char[] language = { 'c', 's', 'h', 'a', 'r', 'p' };
            string strLanguage = new string(language); // inicjalizacja przy użyciu konstruktora
            WriteLine($"{strLanguage}");
            string repeatMe = new string('*', 5);
            WriteLine($"{repeatMe}");
            string[] members = { "Szymon", "Damian", "Wacław", "Gustaw" };
            string name = string.Join(" ", members); // metoda zwracająca łańcuch znaków
            WriteLine($"{name}");
        }

        private static void ArrayExample()
        {
            var charArray = new[] { 'a', 'e', 'i', 'o', 'u', 'ą', 'ę', 'ó', 'y' };
            string[] cardinalDirections = { "północ", "wschód", "południe", "zachód" };
            //char[] vowels = new char[8] { 'a', 'e', 'i', 'o', 'u', 'ą', 'ę', 'ó', 'y' };
            WriteLine("Tablice jednowymiarowe.\n");
            WriteLine("Przykład tablicy.\n");
            char[] vowels = { 'a', 'e', 'i', 'o', 'u', 'ą', 'ę', 'ó', 'y' };
            WriteLine("char[] vowels = {'a', 'e', 'i', 'o', 'u', 'ą', 'ę', 'ó', 'y'};\n");
            WriteLine("Przeglądanie tablicy przy użyciu pętli for");
            for (int rankIndex = 0; rankIndex < vowels.Length; rankIndex++)
            {
                Write($"{vowels[rankIndex]} ");
            }
            WriteLine();
            WriteLine("Przeglądanie tablicy przy użyciu pętli foreach");
            foreach (char vowel in vowels)
            {
                Write($"{vowel} ");
            }

            WriteLine("Tablice dwuwymiarowe.\n");

            //int[,] numbers = new int[2, 2];
            int[,] numbers = new int[2, 2] { { 1, 2 }, { 3, 4 } };
            for (int rowsIndex = 0; rowsIndex < 2; rowsIndex++)
            {
                for (int colIndex = 0; colIndex < 2; colIndex++)
                {
                    WriteLine($"numbers[{rowsIndex},{colIndex}] = {numbers[rowsIndex, colIndex]}");
                }
            }

            WriteLine();
            WriteLine("Tablice nieregularne.\n");
            string[][,] collaborators = new string[3][,]
            {
                new[,] {{"Personalia", "Szymon Krawczyk"}, {"Wiek", "40"}},
                new[,] {{"Personalia", "Gustaw Florek"}, {"Wiek", "43"}},
                new[,] {{"Personalia", "Wacław Kowalski"}, {"Wiek", "28"}}    
            };

            for (int index = 0; index < collaborators.Length; index++)
            {
                for (int rowIndex = 0; rowIndex < 2; rowIndex++)
                {
                    for (int colIndex = 0; colIndex < 2; colIndex++)
                    {
                        WriteLine($"collaborators[{index}][{rowIndex},{colIndex}] = {collaborators[index][rowIndex, colIndex]}");
                    }
                }
            }
        }

        private static void BreakStatementExample()
        {
            WriteLine("Przykład instrukcji break.");
            WriteLine("Użycie break w pętli for:");
            for (int count = 0; count < 50; count++)
            {
                if (count == 8)
                {
                    break;
                }
                WriteLine($"{count}");
            }
            WriteLine();
            WriteLine("Użycie break w instrukcji switch :");
            SwitchCaseExample();
        }

        private static void ContinueStatementExample()
        {
            WriteLine("Przykład instrukcji continue.");
            WriteLine("Użycie continue w pętli for:");
            for (int count = 0; count < 15; count++)
            {
                if (count < 8)
                {
                    continue;
                }
                WriteLine($"{count}");
            }
        }

        private static void ForEachStatementExample()
        {
            WriteLine("Przykład pętli foreach.");
            char[] vowels = { 'a', 'e', 'i', 'o', 'u', 'ą', 'ę', 'ó', 'y' };
            WriteLine("Pętla foreach operująca na tablicy:");
            foreach (var vowel in vowels)
            {
                WriteLine($"{vowel}");
            }
            WriteLine();
            var persons = new List<Person>
            {
                new Author {Name = "Gustaw Florek"},
                new Reviewer {Name = "Szymon Krawczyk"},
                new TeamMember {Name = "Wacław Kowalski"},
                new TeamMember {Name = "Damian Nowak"}
            };
            WriteLine("Pętla foreach operująca na kolekcji:");
            foreach (var person in persons)
            {
                WriteLine($"{person.Name}");
            }
        }

        private static void ForStatementExample()
        {
            WriteLine("Przykład pętli for.");
            Write("Podaj długość: ");
            int length = Convert.ToInt32(ReadLine());
            for (int countIndex = 0; countIndex < length; countIndex++)
            {
                WriteLine(new string('*', countIndex));
            }
        }

        private static void DoWhileStatementExample()
        {
            WriteLine("Przykład pętli do...while.");
            Write("Podaj długość: ");
            int length = Convert.ToInt32(ReadLine());
            int count = 0;
            do
            {
                count++;
                WriteLine(new string('*', count));


            } while (count < length);
        }

        private static void WhileStatementExample()
        {
            WriteLine("Przykład pętli while.");
            Write("Podaj długość: ");
            int length = Convert.ToInt32(ReadLine());
            int count = 0;
            while (count < length)
            {
                count++;
                WriteLine(new string('*', count));
            }

        }

        private static void SwitchCaseExample()
        {
            WriteLine("Przykład instrukcji switch ... case.");
            Write("Wpisz znak:");
            char inputChar = Convert.ToChar(ReadLine());

            switch (char.ToLower(inputChar))
            {
                case 'a':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                case 'e':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                case 'i':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                case 'o':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                case 'u':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                case 'ą':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                case 'ę':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                case 'ó':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                case 'y':
                    WriteLine($"Litera {inputChar} jest samogłoską.");
                    break;
                default:
                    WriteLine($"Litera '{inputChar}' jest spółgłoską.");
                    break;
            }
        }

        private static void NestedIfStatementExample()
        {
            WriteLine("Przykład zagnieżdżonych instrukcji if.");
            Write("Ile masz lat: ");
            int age = Convert.ToInt32(ReadLine());

            if (age < 18)
            {
                WriteLine("Musisz mieć co najmniej 18 lat.");
                if (age < 15)
                {
                    WriteLine("Musisz skończyć przynajmniej szkołę podstawową");
                }
            }
        }

        private static void IfElseIfElseStatementExample()
        {
            WriteLine("Przykład instrukcji if else if else.");
            Write("Wpisz znak:");
            char inputChar = Convert.ToChar(ReadLine());

            if (char.ToLower(inputChar) == 'a')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else if (char.ToLower(inputChar) == 'e')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else if (char.ToLower(inputChar) == 'i')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else if (char.ToLower(inputChar) == 'o')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else if (char.ToLower(inputChar) == 'u')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else if (char.ToLower(inputChar) == 'ą')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else if (char.ToLower(inputChar) == 'ę')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else if (char.ToLower(inputChar) == 'ó')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else if (char.ToLower(inputChar) == 'y')
            { WriteLine($"Litera {inputChar} jest samogłoską."); }
            else
            { WriteLine($"Litera '{inputChar}' jest spółgłoską."); }
        }

        private static void IfStatementExample()
        {
            WriteLine("Przykład instrukcji if.");
            Write("Wpisz znak:");
            char inputChar = Convert.ToChar(ReadLine());

            // tak dużo instrukcji if, kompilator musi przeglądać je wszystkie;
            // takie rozwiązanie nie jest zalecane
            if (char.ToLower(inputChar) == 'a')
                WriteLine($"Litera {inputChar} jest samogłoską.");
            if (char.ToLower(inputChar) == 'e')
                WriteLine($"Litera {inputChar} jest samogłoską.");
            if (char.ToLower(inputChar) == 'i')
                WriteLine($"Litera {inputChar} jest samogłoską.");
            if (char.ToLower(inputChar) == 'o')
                WriteLine($"Litera {inputChar} jest samogłoską.");
            if (char.ToLower(inputChar) == 'u')
                WriteLine($"Litera {inputChar} jest samogłoską.");
        }

        private static void IfElseStatementExample()
        {
            WriteLine("Przykład instrukcji if ... else.");
            Write("Wpisz znak:");
            char inputChar = Convert.ToChar(ReadLine());
            char[] vowels = { 'a', 'e', 'i', 'o', 'u', 'ą', 'ę', 'ó', 'y' };

            if (vowels.Contains(char.ToLower(inputChar)))
                WriteLine($"Litera '{inputChar}' jest samogłoską.");
            else
                WriteLine($"Litera '{inputChar}' jest spółgłoską.");
        }

        private static void StatementExample()
        {
            WriteLine("Przykład instrukcji:");
            int singleLineStatement; // instrukcja deklaracji
            WriteLine("'int singleLineStatement;' to instrukcja deklaracji");
            singleLineStatement = 125; // instrukcja przypisania
            WriteLine("'singleLineStatement = 125;' to instrukcja przypisania.");
            WriteLine($"{nameof(singleLineStatement)} = {singleLineStatement}");
            var persons = new List<Person>
            {
                new Author
                {
                    Name = "Gustaw Florek"
                }
            }; // instrukcja deklaracji i przypisania
            WriteLine("'var persons = new List<Person>();' to przykład instrukcji deklaracji i przypisania.");
            // instrukcja blokowa
            foreach (var person in persons)
            {
                WriteLine("'foreach (var person in persons){}' to przykład instrukcji blokowej.");
                WriteLine($"Personalia: {person.Name}");
            }
        }

        private static void ImplicitExplicitTypeConversionExample()
        {
            WriteLine("Konwersja niejawna");
            int numberInt = 2589;
            double doubleNumber = numberInt; // niejawna konwersja typów

            WriteLine($"Zmienna {nameof(numberInt)} typu {numberInt.GetType().FullName} ma wartość: {numberInt}");
            WriteLine($"Zmienna {nameof(doubleNumber)} typu {doubleNumber.GetType().FullName} rzutowana niejawnie ma wartość: {doubleNumber}");

            WriteLine("Konwersja jawna");
            doubleNumber = 2589.05D;
            numberInt = (int)doubleNumber; // jawna konwersja typów
            WriteLine($"Zmienna {nameof(doubleNumber)} typu {doubleNumber.GetType().FullName} ma wartość: {doubleNumber}");
            WriteLine($"Zmienna {nameof(numberInt)} typu {numberInt.GetType().FullName} rzutowana jawnie ma wartość: {numberInt}");

        }

        private static void OperatorOverloadingExample()
        {
            WriteLine("Przykład przeciążania operatorów\n");
            Write("Wpisz wartość współrzędnej x zmiennej surface1: ");
            var x1 = ReadLine();
            Write("Wpisz wartość współrzędnej y zmiennej surface1: ");
            var y1 = ReadLine();
            Write("Wpisz wartość współrzędnej x zmiennej surface2: ");
            var x2 = ReadLine();
            Write("Wpisz wartość współrzędnej y zmiennej surface2: ");
            var y2 = ReadLine();

            var surface1 = new Coordinate(Convert.ToInt32(x1), Convert.ToInt32(y1));
            var surface2 = new Coordinate(Convert.ToInt32(x2), Convert.ToInt32(y2));
            WriteLine();
            Clear();
            WriteLine($"Zmienna surface1:{surface1}");
            WriteLine($"Pole surface1:{surface1.Area()}");
            WriteLine($"Zmienna surface2:{surface2}");
            WriteLine($"Pole surface2:{surface2.Area()}");
            WriteLine();
            WriteLine($"surface1 == surface2: {surface1 == surface2}");
            WriteLine($"surface1 < surface2: {surface1 < surface2}");
            WriteLine($"surface1 > surface2: {surface1 > surface2}");
            WriteLine($"surface1 <= surface2: {surface1 <= surface2}");
            WriteLine($"surface1 >= surface2: {surface1 >= surface2}");
            WriteLine();
            var surface3 = surface1 + surface2;
            WriteLine($"Dodawanie: {nameof(surface1)} + {nameof(surface2)} = {surface3}");
            WriteLine($"{nameof(surface3)}:{surface3}");
            WriteLine($"Pole {nameof(surface3)}: {surface3.Area()} ");
            WriteLine();
            WriteLine($"Odejmowanie: {nameof(surface1)} - {nameof(surface2)} = {surface1 - surface2}");
            WriteLine($"Mnożenie: {nameof(surface1)} * {nameof(surface2)} = {surface1 * surface2}");
            WriteLine($"Dzielenie: {nameof(surface1)} / {nameof(surface2)} = {surface1 / surface2}");
            WriteLine($"Modulo: {nameof(surface1)} % {nameof(surface2)} = {surface1 % surface2}");
        }

        private static void OperatorExample()
        {
            WriteLine("Przykłady operatorów\n");
            var csharpOperator = new CSharpOperator();
            Write("Podaj pierwszą liczbę:");
            csharpOperator.Num1 = Convert.ToInt32(ReadLine());
            Write("Podaj drugą liczbę:");
            csharpOperator.Num2 = Convert.ToInt32(ReadLine());
            Clear();
            csharpOperator.Display();
            ;
        }

        private static void BoxingUnboxingExample()
        {
            int thisIsvalueTypeVariable = 786;
            object thisIsObjectTypeVariable = thisIsvalueTypeVariable; // Pakowanie
            thisIsvalueTypeVariable += 1;
            WriteLine("Pakowanie");
            WriteLine($"Przed spakowaniem: Wartość {nameof(thisIsvalueTypeVariable)} wynosi {thisIsvalueTypeVariable}");
            WriteLine($"Po spakowaniu: Wartość {nameof(thisIsObjectTypeVariable)} wynosi {thisIsObjectTypeVariable}");

            thisIsObjectTypeVariable = 1900;
            thisIsvalueTypeVariable = (int)thisIsObjectTypeVariable; // Rozpakowywanie
            WriteLine("Rozpakowywanie");
            WriteLine($"Przed rozpakowaniem: Wartość {nameof(thisIsObjectTypeVariable)} wynosi {thisIsObjectTypeVariable}");
            WriteLine($"Po rozpakowaniu: Wartość {nameof(thisIsvalueTypeVariable)} wynosi {thisIsvalueTypeVariable}");
        }

        private static void DataTypeExample()
        {
            CSharpType.Display();
        }

        private static void DynamicTypeExample()
        {
            dynamic dynamicInt = 10;
            dynamic dynamicString = "To jest łańcuch znaków.";
            object obj = 10;
            WriteLine($"Typem czasu wykonywania zmiennej {nameof(dynamicInt)} jest {dynamicInt.GetType()}");
            WriteLine($"Typem czasu wykonywania zmiennej {nameof(dynamicString)} jest {dynamicString.GetType()}");
            WriteLine($"Typem czasu wykonywania zmiennej {nameof(obj)} jest {obj.GetType()}");

        }

        private static void UsingExample()
        {
            //Console.WriteLine("Ta metoda WriteLien jest wywoływana bez użycia dyrektywy using static.");
            //WriteLine("Tego wywołania WriteLien można używać do umieszczania w kodzie dyrektywy using static.");

            using (var disposableClass = new DisposableClass())
            {
                WriteLine($"{disposableClass.GetMessage()}");
            }
        }

        private static void TypeofExample()
        {

            var thisIsADouble = 30.3D;
            WriteLine("Zastosowanie typeof()");
            WriteLine($"Obiekt System.Type dla typu {nameof(Program)} to {typeof(Program)}\n");
            var objProgram = new Program();
            WriteLine("using GetType()");
            WriteLine($"Obiekt System.Type dla {nameof(objProgram)} to {objProgram.GetType()}");
            WriteLine($"Obiekt System.Type dla {nameof(thisIsADouble)} to {thisIsADouble.GetType()}");
        }

        private static void SizeofExample()
        {
            WriteLine("Wielkości (liczone w bajtach) różnych wbudowanych typów danych:\n");
            WriteLine($"Typ int ma wielkość {sizeof(int)} bajtów.");
            WriteLine($"Typ long ma wielkość {sizeof(long)} bajtów.");
            WriteLine($"Typ double ma wielkość {sizeof(double)} bajtów.");
            WriteLine($"Typ bool ma wielkość {sizeof(bool)} bajta.");
            WriteLine($"Typ short ma wielkość {sizeof(short)} bajtów.");
            WriteLine($"Typ byte ma wielkość {sizeof(byte)} bajta.");
        }



        private static void CheckOverFlowExample()
        {
            const int maxValue = int.MaxValue;
            const int addSugar = 19;

            //int sumWillthrowError = 2147483647 + 19; // błąd czasu kompilacji
            var sumWillNotThrowError = unchecked(maxValue + addSugar);
            //var sumWillNotThrowError = checked(maxValue + addSugar); // błąd czasu kompilacji
            WriteLine(
                $"Suma:{sumWillNotThrowError} nie jest prawidłową wartością, gdyż jest większa od {maxValue}.");
        }

        private static void ExampleIsAsOperator()
        {
            WriteLine("Operator as");
            var author = new Author { Name = "Gustaw Florek" }; 
            var stackholder = new Stackholder();

            WriteLine("Imię autora z użyciem as:\n");
            stackholder.GetAuthorName(author);
        }

        private static void ConsoleBeepExample()
        {
            for (var i = 0; i < 9; i++)
                Beep();
        }

        private static void ConsoleOperationExamples()
        {
            WriteLine("Przykład kolorowania tekstu wyświetlanego na konsoli\n");
            var colors = (ConsoleColor[])Enum.GetValues(typeof(ConsoleColor));
            WriteLine("Wszystkie dostępne kolory:");
            (int background, int foreground) userInput;
            do
            {
                userInput = DisplayColorMenu(colors);
                if (userInput.foreground == colors.Length + 1 || userInput.background == colors.Length + 1)
                {
                    WriteLine("Przywracanie domyślnych kolorów...");
                    ResetColor();
                    Write("Naciśnij dowolny klawisz, aby kontunuować...");
                    ReadLine();
                    Clear();
                    userInput = DisplayColorMenu(colors);
                }
                else if (userInput.foreground < 0 || userInput.background < 0)
                {
                    WriteLine("-ve wartości nie są dozwolone.");
                    Clear();
                    userInput = DisplayColorMenu(colors);
                }
                else if (userInput.background == colors.Length + 2 || userInput.foreground == colors.Length + 2)
                {
                }
                else
                {
                    BackgroundColor = colors[userInput.background];
                    ForegroundColor = colors[userInput.foreground];

                    WriteLine($"Wybrany kolor tekstu to {ForegroundColor}");
                    WriteLine($"Wybrany kolor tła to {BackgroundColor}");
                    WriteLine();

                    Write("Wpisz coś, aby zobaczyć zmienione kolory tekstu: ");
                    ReadLine();
                }
            } while (userInput.background != colors.Length + 2 || userInput.foreground != colors.Length + 2);
        }

        private static (int, int) DisplayColorMenu(ConsoleColor[] colors)
        {
            var count = 0;

            foreach (var color in colors)
            {
                WriteLine($"{count} {color}");
                count += 1;
            }
            WriteLine($"{count + 1} Ustawienia początkowe");
            WriteLine($"{count + 2} Wyjście");

            Write("Wybierz kolor tekstu:");
            var foreground = Convert.ToInt32(ReadLine());
            Write("Wybierz kolor tła:");
            var background = Convert.ToInt32(ReadLine());

            return new ValueTuple<int, int>(background, foreground);
        }

        private static void SameClassDifferentNamespacesExample()
        {
            var class1 = new ClassExample();
            var class2 = new Dzien02Nowa.ClassExample();
            class1.Display();
            class2.Display();
        }
    }
}