﻿using System;
using static System.Console;

namespace Dzien06
{
    public class ErrorLogger : Attribute
    {
        public ErrorLogger(string exception)
        {
            switch (Env)
            {
                case Env.Debug:
                case Env.Dev:
                    WriteLine($"{exception}");
                    throw new Exception(exception);
                case Env.Prod:
                    WriteLine($"{exception}");
                    break;
                default:
                    WriteLine($"{exception}");
                    throw new Exception(exception);
            }
        }


        public Env Env { get; set; }
    }

    public enum Env
    {
        Debug,
        Dev,
        Prod
    }


    public class MathClass
    {
        [ErrorLogger("Operacja Add jest w trakcie implementacji!", Env = Env.Debug)]
        public string Add(int num1, int num2)
        {
            return $"Suma liczb {num1} oraz {num2} wynosi: {num1 + num2}";
        }

        [ErrorLogger("Operacja Subtract jest w trakcie implementacji!", Env = Env.Dev)]
        public string Substract(int num1, int num2)
        {
            return $"Różnica liczb {num1} i {num2} wynosi: {num1 - num2}";
        }

        [ErrorLogger("Operacja Multiply jest w trakcie implementacji!", Env = Env.Prod)]
        public string Multiply(int num1, int num2)
        {
            return $"Iloczyn liczb {num1} i {num2} wynosi: {num1 * num2}";
        }
    }

    public class FilePolling
    {
        public void PoleAFile(string fileName)
        {
            Console.Write($"To jest plik ankiety: {fileName}");
            // kod obsługi ankiety
        }

        public async void PoleAFileAsync(string fileName)
        {
            Console.Write($"To jest plik ankiety: {fileName}");
            // asynchroniczny kod obsługi ankiety
        }
    }
}