/*
 * Copyright 2013 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


import javax.jms.MessageListener;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.JMSException;


/**
 * Klasa TextListener implementuje interfejs MessageListener,
 * definiujc metod onMessage method, ktra wywietla
 * zawarto TextMessage.
 *
 * Klasa jest wykorzystywana przez klas SimpleAsynchConsumer.
 */
public class TextListener implements MessageListener {
    /**
     * Rzutuje komunikat na TextMessage i wywietla jego zawarto.
     *
     * @param message     przychodzcy komunikat
     */
    public void onMessage(Message message) {
        TextMessage msg = null;

        try {
            if (message instanceof TextMessage) {
                msg = (TextMessage) message;
                System.out.println("Otrzymano komunikat: " + msg.getText());
            } else {
                System.err.println("Komunikat nie jest typu TextMessage");
            }
        } catch (JMSException e) {
            System.err.println("Wyjtek JMSException w onMessage(): " + e.toString());
        } catch (Throwable t) {
            System.err.println("Wyjtek w onMessage():" + t.getMessage());
        }
    }
}
