/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collections;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;

public class HumanResourceClient {
    @Resource(lookup="jms/ConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(lookup="jms/Topic")
    private static Topic pubTopic;
    static final Object waitUntilDone;
    static SortedSet<Integer> outstandingRequests;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection connection = null;
        try {
            Random rand = new Random();
            int nextHireID = rand.nextInt(100);
            String[] positions = new String[]{"programista", "starszy programista", "kierownik", "dyrektor"};
            String[] names = new String[]{"Stefan Rogala", "Dawid Rado\u0142a", "Oskar Borkowski", "Stanis\u0142aw Serowski", "Diana Kr\u00f3l", "Amanda Weso\u0142kowska", "Agata Radzi\u0142ow", "Damian Jagie\u0142\u0142o", "Helena Rob\u00f3tka", "Adrianna Klepka", "G\u0142owos\u0142aw Jacyk\u00f3w", "Marek Jankowski", "Henryk Budka", "Marian Tudorka", "Gertruda Z\u0105bek", "Jan Nowak", "Apolonia W\u0105s", "Tomasz Kowalski", "Maria Budny", "Beata Bourbon", "Karol Jasny", "Robert Mokry"};
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            TemporaryQueue replyQueue = session.createTemporaryQueue();
            MessageConsumer consumer = session.createConsumer((Destination)replyQueue);
            consumer.setMessageListener((MessageListener)new HRListener());
            connection.start();
            MessageProducer producer = session.createProducer((Destination)pubTopic);
            MapMessage message = session.createMapMessage();
            message.setJMSReplyTo((Destination)replyQueue);
            int[] order = HumanResourceClient.getorder();
            for (int i = 0; i < 5; ++i) {
                int currentHireID = nextHireID++;
                message.setString("HireID", String.valueOf(currentHireID));
                message.setString("Name", names[order[i]]);
                message.setString("Position", positions[rand.nextInt(positions.length)]);
                System.out.println("PRODUCENT: Ustawiam identyfikator na " + message.getString("HireID") + ", imi\u0119 i nazwisko to " + message.getString("Name") + ", a stanowisko to " + message.getString("Position"));
                producer.send((Message)message);
                outstandingRequests.add(new Integer(currentHireID));
            }
            System.out.println("Czekam na " + outstandingRequests.size() + " komunikat\u00f3w");
            Object object = waitUntilDone;
            synchronized (object) {
                waitUntilDone.wait();
            }
        }
        catch (Exception e) {
            System.err.println("HumanResourceClient: Wyj\u0105tek: " + e.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    System.err.println("HumanResourceClient: Wyj\u0105tek zamkni\u0119cia: " + e.toString());
                }
            }
            System.exit(0);
        }
    }

    public static int[] getorder() {
        int[] order = new int[24];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        Random rgen = new Random();
        for (int i = 0; i < order.length; ++i) {
            int randomPosition = rgen.nextInt(order.length);
            int temp = order[i];
            order[i] = order[randomPosition];
            order[randomPosition] = temp;
        }
        return order;
    }

    static {
        waitUntilDone = new Object();
        outstandingRequests = Collections.synchronizedSortedSet(new TreeSet());
    }

    static class HRListener
    implements MessageListener {
        HRListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            MapMessage msg = (MapMessage)message;
            try {
                System.out.println("Przetworzono zadarzenie nowego pracownika:");
                Integer id = Integer.valueOf(msg.getString("employeeId"));
                System.out.println("  Identyfikator: " + id);
                System.out.println("  Imi\u0119 i nazwisko: " + msg.getString("employeeName"));
                System.out.println("  Sprz\u0119t: " + msg.getString("equipmentList"));
                System.out.println("  Numer biura: " + msg.getString("officeNumber"));
                outstandingRequests.remove(id);
            }
            catch (JMSException je) {
                System.out.println("HRListener.onMessage(): Wyj\u0105tek: " + je.toString());
            }
            if (outstandingRequests.size() == 0) {
                Object object = waitUntilDone;
                synchronized (object) {
                    waitUntilDone.notify();
                }
            } else {
                System.out.println("Czekam na " + outstandingRequests.size() + " komunikat\u00f3w");
            }
        }
    }
}

