/*
 * Decompiled with CFR 0.152.
 */
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class AckEquivExample {
    @Resource(lookup="jms/ConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(lookup="jms/DurableConnectionFactory")
    private static ConnectionFactory durableConnectionFactory;
    @Resource(lookup="jms/ControlQueue")
    private static Queue controlQueue;
    @Resource(lookup="jms/Queue")
    private static Queue queue;
    @Resource(lookup="jms/Topic")
    private static Topic topic;
    final String CONTROL_QUEUE = "jms/ControlQueue";
    final String conFacName = "jms/DurableConnectionFactory";
    final String queueName = "jms/Queue";
    final String topicName = "jms/Topic";

    public void run_threads() {
        SynchSender synchSender = new SynchSender();
        SynchReceiver synchReceiver = new SynchReceiver();
        AsynchSubscriber asynchSubscriber = new AsynchSubscriber();
        MultiplePublisher multiplePublisher = new MultiplePublisher();
        synchSender.start();
        synchReceiver.start();
        try {
            synchSender.join();
            synchReceiver.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            asynchSubscriber.start();
            Thread.sleep(1000L);
            multiplePublisher.start();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            asynchSubscriber.join();
            multiplePublisher.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        AckEquivExample aee = new AckEquivExample();
        if (args.length != 0) {
            System.out.println("Program nie przyjmuje \u017cadnych argument\u00f3w.");
            System.exit(1);
        }
        System.out.println("Nazwa kolejki: " + aee.CONTROL_QUEUE);
        System.out.println("Nazwa kolejki: " + aee.queueName);
        System.out.println("Nazwa tematu: " + aee.topicName);
        System.out.println("Nazwa fabryki po\u0142\u0105cze\u0144: " + aee.conFacName);
        aee.run_threads();
        System.exit(0);
    }

    public class SynchSender
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            Session session = null;
            MessageProducer producer = null;
            String MSG_TEXT = "Oto komunikat dotycz\u0105cy typu client-acknowledge";
            TextMessage message = null;
            try {
                connection = connectionFactory.createConnection();
                session = connection.createSession(false, 2);
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem: " + e.toString());
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException ee) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
            try {
                System.out.println("  NADAWCA: Utworzono sesj\u0119 typuy client-acknowledge");
                producer = session.createProducer((Destination)queue);
                message = session.createTextMessage();
                message.setText("Oto komunikat dotycz\u0105cy typu client-acknowledge");
                System.out.println("  NADAWCA: Wysy\u0142anie komunikatu: " + message.getText());
                producer.send((Message)message);
            }
            catch (JMSException e) {
                System.err.println("Wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {}
                }
            }
        }
    }

    public class SynchReceiver
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            Session session = null;
            MessageConsumer receiver = null;
            TextMessage message = null;
            try {
                connection = connectionFactory.createConnection();
                session = connection.createSession(false, 2);
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem: " + e.toString());
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException ee) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
            try {
                System.out.println("  ODBIORCA: Utworzono sesj\u0119 typu client-acknowledge");
                receiver = session.createConsumer((Destination)queue);
                connection.start();
                message = (TextMessage)receiver.receive();
                System.out.println("  ODBIORCA: Przetwarzanie komunikatu: " + message.getText());
                System.out.println("  ODBIORCA: Teraz potwierdz\u0119 komunikat");
                message.acknowledge();
            }
            catch (JMSException e) {
                System.err.println("Wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {}
                }
            }
        }
    }

    public class MultiplePublisher
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            Session session = null;
            MessageProducer publisher = null;
            TextMessage message = null;
            int NUMMSGS = 3;
            String MSG_TEXT = "Oto komunikat dotycz\u0105cy typu auto-acknowledge";
            try {
                connection = connectionFactory.createConnection();
                session = connection.createSession(false, 1);
                System.out.println("PRODUCENT: Utworzono sesj\u0119 typu auto-acknowledge");
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem u producenta: " + e.toString());
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException ee) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
            try {
                try {
                    SampleUtilities.receiveSynchronizeMessages("PRODUCENT: ", connectionFactory, controlQueue, 1);
                }
                catch (Exception e) {
                    System.err.println("Problem z po\u0142\u0105czeniem lub kolejk\u0105 u producenta: " + e.toString());
                    e.printStackTrace();
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (JMSException ee) {
                            // empty catch block
                        }
                    }
                    System.exit(1);
                }
                publisher = session.createProducer((Destination)topic);
                message = session.createTextMessage();
                for (int i = 0; i < 3; ++i) {
                    message.setText("Oto komunikat dotycz\u0105cy typu auto-acknowledge " + (i + 1));
                    System.out.println("PRODUCENT: Publikacja komunikatu: " + message.getText());
                    publisher.send((Message)message);
                }
                publisher.send(session.createMessage());
            }
            catch (JMSException e) {
                System.err.println("Wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {}
                }
            }
        }
    }

    public class AsynchSubscriber
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            Session session = null;
            TopicSubscriber subscriber = null;
            TextListener listener = null;
            try {
                connection = durableConnectionFactory.createConnection();
                session = connection.createSession(false, 1);
                System.out.println("SUBSKRYBENT: Utworzono sesj\u0119 typu auto-acknowledge");
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem subskrybenta: " + e.toString());
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException ee) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
            try {
                subscriber = session.createDurableSubscriber(topic, "AckSub");
                listener = new TextListener();
                subscriber.setMessageListener((MessageListener)listener);
                connection.start();
                try {
                    SampleUtilities.sendSynchronizeMessage("SUBSKRYBENT: ", connectionFactory, controlQueue);
                }
                catch (Exception e) {
                    System.err.println("Problem z po\u0142\u0105czeniem lub kolejk\u0105 subskrybenta: " + e.toString());
                    e.printStackTrace();
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (JMSException ee) {
                            // empty catch block
                        }
                    }
                    System.exit(1);
                }
                listener.monitor.waitTillDone();
                subscriber.close();
                session.unsubscribe("AckSub");
            }
            catch (JMSException e) {
                System.err.println("Wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {}
                }
            }
        }

        private class TextListener
        implements MessageListener {
            final SampleUtilities.DoneLatch monitor = new SampleUtilities.DoneLatch();

            private TextListener() {
            }

            public void onMessage(Message message) {
                if (message instanceof TextMessage) {
                    TextMessage msg = (TextMessage)message;
                    try {
                        System.out.println("SUBSKRYBENT: Przetwarzanie komunikatu: " + msg.getText());
                    }
                    catch (JMSException e) {
                        System.err.println("Wyj\u0105tek w onMessage(): " + e.toString());
                    }
                } else {
                    this.monitor.allDone();
                }
            }
        }
    }
}

