#import "Fraction.h"
#import <stdio.h>

static int gCounter;

@implementation Fraction;

+(Fraction *) allocF
{
	extern int gCounter;

	++gCounter;

	return [Fraction alloc];
}

+(int) count
{
	extern int gCounter;

	return gCounter;
}

-(Fraction *) initWith: (int) n: (int) d
{
	[super init];

	[self setTo: n  over: d];

	return self;
}

-(void) setNumerator: (int) n
{
	numerator = n;
}

-(void) setDenominator: (int) d
{
	denominator = d;
}

-(int)  numerator 
{
	return numerator;
}

-(int) denominator
{
	return denominator;
}

-(double) convertToNum
{
	if (denominator != 0)
		return (double) numerator / denominator;
	else
		return 1.0;
}

-(void) setTo: (int) n over: (int) d
{
	numerator = n;
	denominator = d;
}

- (void) reduce
{
	int	u = numerator;
	int	v = denominator;
	int	temp;

	if (u < 0)
		u = -u;

	while (v != 0) {
		temp = u % v;
		u = v;
		v = temp;
	}

	numerator /= u;
	denominator /= u;
}	


-(void) print 
{
	printf (" %i/%i ", numerator, denominator);
}
@end


