#import "Fraction.h"
#import <stdio.h>

@implementation Fraction;
-(void) print 
{
	printf (" %i/%i ", numerator, denominator);
}

-(void) setNumerator: (int) n
{
	numerator = n;
}

-(void) setDenominator: (int) d
{
	denominator = d;
}

-(int) numerator 
{
	return numerator;
}

-(int) denominator
{
	return denominator;
}

-(double) convertToNum
{
	if (denominator != 0)
		return (double) numerator / denominator;
	else
		return 1.0;
}

-(void) setTo: (int) n over: (int) d
{
	numerator = n;
	denominator = d;
}

// Dodanie obiektu Fraction

-(Fraction *) add: (Fraction *) f
{
	// dodanie dwch uamkw:
	// a/b + c/d = ((a*d) + (b*c)) / (b * d)

	// wynik zostanie zapisany w zmiennej result
	Fraction 	*result = [[Fraction alloc] init];
	int 		resultNum, resultDenom;

	resultNum = (numerator * [f denominator]) + 
		(denominator * [f numerator]);
	resultDenom = denominator * [f denominator];

	[result setTo: resultNum over: resultDenom];
	[result reduce];

	return result;
}

- (void) reduce
{
	int	u = numerator;
	int	v = denominator;
	int	temp;

	while (v != 0) {
		temp = u % v;
		u = v;
		v = temp;
	}

	numerator /= u;
	denominator /= u;
}	
@end
