// Plik: fig23_03.cpp
// Przekazanie obiektu szablonu
// stosu do szablonu funkcji
#include <iostream>
#include <string>
#include "Stack.h" // Definicja szablonu klasy Stack
using namespace std;

// Szablon funkcji przeznaczonej do przeprowadzania operacji na obiekcie typu Stack< T >
template< typename T >  
void testStack(  
   Stack< T > &theStack, // Odwołanie do obiektu typu Stack< T >
   const T &value, // Wartość początkowa do umieszczenia na stosie 
   const T &increment, // Inkrementacja kolejnych wartości
   size_t size, // Liczba elementów do umieszczenia na stosie       
   const string &stackName ) // Nazwa obiektu typu Stack< T >
{                                                           
   cout << "\nUmieszczanie elementów na stosie " << stackName << '\n'; 
   T pushValue = value;
                                                            
   // Umieszczanie elementów na stosie                               
   for ( size_t i = 0; i < size; ++i )
   {
      theStack.push( pushValue ); // Umieszczanie elementów na stosie
      cout << pushValue << ' ';
      pushValue += increment;
   } // Koniec pętli while
                                                            
   cout << "\n\nUsuwanie elementów ze stosu " << stackName << '\n'; 
                                                            
   // Usuwanie elementów ze stosu                               
   while ( !theStack.isEmpty() ) // Iteracja przez stos, o ile nie jest pusty
   {
      cout << theStack.top() << ' ';
      theStack.pop(); // Usunięcie elementu znajdującego się na wierzchu stosu
   } // Koniec pętli while
                                                            
   cout << "\nStos jest pusty, nie można usunąć elementu." << endl;                
} // Koniec funkcji szablonu testStack()                               

int main()
{
   Stack< double > doubleStack; 
   const size_t doubleStackSize = 5;
   testStack( doubleStack, 1.1, 1.1, doubleStackSize, "doubleStack" );

   Stack< int > intStack; 
   const size_t intStackSize = 10;
   testStack( intStack, 1, 1, intStackSize, "intStack" );
} // Koniec funkcji main()
