// Plik: fig11_07.c
// Program pobierający informacje o saldach klientów
#include <stdio.h>

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{ 
   FILE *cfPtr; // Wskaźnik pliku client.txt

   // Funkcja fopen() otwiera plik. Jeżeli plik nie może zostać otworzony, nastąpi zakończenie działania programu
   if ((cfPtr = fopen("clients.txt", "r")) == NULL) {
      puts("Nie udało się otworzyć pliku.");
   } 
   else { 
      
      // Wyświetlenie dostępnych opcji
      printf("%s", "Wybierz opcję:\n"
         " 1 - lista kont z saldem zerowym\n"
         " 2 - lista kont z saldem ujemnym\n"
         " 3 - lista kont z saldem dodatnim\n"
         " 4 - koniec pracy\n? ");
      unsigned int request; // Numer wybranej opcji
      scanf("%u", &request);

      // Przetworzenie danych wejściowych użytkownika
      while (request != 4) { 
         unsigned int account; // Numer konta
         double balance; // Saldo konta klienta
         char name[30]; // Nazwisko klienta

         // Odczytanie następujących danych z pliku: numer konta, nazwisko klienta i saldo konta klienta          
         fscanf(cfPtr, "%d%29s%lf", &account, name, &balance);

         switch (request) { 
            case 1:
               puts("\nKonta z saldem zerowym:");

               // Odczytywanie zawartości pliku (aż do napotkania znaku EOF)
               while (!feof(cfPtr)) { 
                  // Dane wyjściowe zostaną wygenerowane tylko wtedy, gdy wartością zmiennej balance jest 0
                  if (balance == 0) {
                     printf("%-10d%-13s%7.2f\n", 
                        account, name, balance);
                  } 

                  // Odczytanie następujących danych z pliku: numer konta, nazwisko klienta i saldo konta klienta
                  fscanf(cfPtr, "%d%29s%lf",
                     &account, name, &balance); 
               } 

               break;
            case 2:
               puts("\nKonta z saldem ujemnym:\n");

               // Odczytywanie zawartości pliku (aż do napotkania znaku EOF)
               while (!feof(cfPtr)) { 
                  // Dane wyjściowe zostaną wygenerowane tylko wtedy, gdy wartość zmiennej balance jest mniejsza niż 0
                  if (balance < 0) {
                     printf("%-10d%-13s%7.2f\n", 
                        account, name, balance);
                  } 

                  // Odczytanie następujących danych z pliku: numer konta, nazwisko klienta i saldo konta klienta
                  fscanf(cfPtr, "%d%29s%lf" ,
                     &account, name, &balance);
               }

               break;
            case 3:
               puts("\nKonta z saldem dodatnim:\n");

               // Odczytywanie zawartości pliku (aż do napotkania znaku EOF)
               while (!feof(cfPtr)) { 
                  // Dane wyjściowe zostaną wygenerowane tylko wtedy, gdy wartość zmiennej balance jest większa niż 0
                  if (balance > 0) {
                     printf("%-10d%-13s%7.2f\n", 
                        account, name, balance);
                  } 

                  // Odczytanie następujących danych z pliku: numer konta, nazwisko klienta i saldo konta klienta
                  fscanf(cfPtr, "%d%29s%lf",
                     &account, name, &balance);
               } 

               break;           
         } 

         rewind(cfPtr); // Wyzerowanie wskaźnika cfPtr, aby prowadził na początek pliku

         printf("%s", "\n? ");
         scanf("%d", &request);
      } 

      puts("Koniec pracy");
      fclose(cfPtr); // Funkcja fclose() zamyka plik
   } 
}
