// Plik: fig10_16.c
// Stosowanie w strukturze pól bitowych elementów składowych
#include <stdio.h>
#define CARDS 52

// Definicja struktury bitCard wraz z polami bitowymi
struct bitCard {
   unsigned int face : 4; // 4 bity, przechowuje wartości z przedziału 0-15.
   unsigned int suit : 2; // 2 bity, przechowuje wartości z przedziału 0-3.
   unsigned int color : 1; // 1 bit, przechowuje wartości z przedziału 0-1
};

typedef struct bitCard Card; // Nowa nazwa typu dla struktury bitCard

void fillDeck(Card * const wDeck); // Prototyp funkcji
void deal(const Card * const wDeck); // Prototyp funkcji

int main(void)
{ 
   Card deck[CARDS]; // Utworzenie tablicy Cards

   fillDeck(deck);

   puts("Figura (0-12) odpowiada wartościom od asa do króla ");
   puts("Kolor (0-3) odpowiada wartościom kier, karo, trefl i pik ");
   puts("Kolor2 (0-1) odpowiada kolorom czerwonemu i czarnemu\n");
   deal(deck);
}

// Inicjalizacja kart
void fillDeck(Card *const wDeck)
{ 
   // Iteracja przez tablicę wDeck
   for (size_t i = 0; i < CARDS; ++i) { 
      wDeck[i].face = i % (CARDS / 4);
      wDeck[i].suit = i / (CARDS / 4);
      wDeck[i].color = i / (CARDS / 2);
   }
}

// Dane wyjściowe są wyświetlane w dwóch kolumnach. Karty 0-25 są indeksowane za pomocą
// k1 (kolumna 1), natomiast karty 26-51 są indeksowane za pomocą k2 (kolumna 2)
void deal(const Card * const wDeck)
{ 
   printf("%-8s%-7s%-16s%-8s%-7s%s\n", "Figura", "Kolor", "Kolor2",
      "Figura", "Kolor", "Kolor2");

   // Iteracja przez tablicę wDeck
   for (size_t k1 = 0, k2 = k1 + 26; k1 < CARDS / 2; ++k1, ++k2) { 
      printf("Figura:%3d  Kolor:%2d  Kolor2:%2d   ",
         wDeck[k1].face, wDeck[k1].suit, wDeck[k1].color);
      printf("Figura:%3d  Kolor:%2d  Kolor2:%2d\n",
         wDeck[k2].face, wDeck[k2].suit, wDeck[k2].color);
   }
}
