// Plik: fig07_26.c
// Program sortujący tablicę w wybranej kolejności z użyciem wskaźników do funkcji
#include <stdio.h>
#define SIZE 10

// Prototyp funkcji
void bubble(int work[], size_t size, int (*compare)(int a, int b));
int ascending(int a, int b);
int descending(int a, int b);

int main(void)
{
   // Inicjalizacja nieposortowanej tablicy a
   int a[SIZE] = { 2, 6, 4, 8, 10, 12, 89, 68, 45, 37 };

   printf("%s", "Opcja 1 oznacza sortowanie w kolejności rosnącej,\n" 
           "opcja 2 oznacza sortowanie w kolejności malejącej: ");
   int order; // Wartość 1 oznacza sortowanie w kolejności rosnącej, a wartość 2 – w kolejności malejącej
   scanf("%d", &order);

   puts("\nElementy danych w pierwotnej kolejności:");
   
   // Wyświetlenie pierwotnej tablicy
   for (size_t counter = 0; counter < SIZE; ++counter) {
      printf("%5d", a[counter]);
   } 

   // Sortowanie tablicy w kolejności rosnącej; przekazanie funkcji ascending() jako
   // argumentu i tym samym wskazanie na sortowanie w kolejności rosnącej
   if (order == 1) {
      bubble(a, SIZE, ascending);
      puts("\nElementy danych w kolejności rosnącej:");
   } 
   else { // Przekazanie funkcji descending()
      bubble(a, SIZE, descending);
      puts("\nElementy danych w kolejności malejącej:");
   } 

   // Wyświetlenie posortowanej tablicy
   for (size_t counter = 0; counter < SIZE; ++counter) {
      printf("%5d", a[counter]);   
   } 

   puts("\n");
} 

// Funkcja sortowania bąbelkowego; parametr compare to wskaźnik do
// funkcji porównującej, która ustala kolejność sortowania
void bubble(int work[], size_t size, int (*compare)(int a, int b))
{
   void swap(int *element1Ptr, int *element2ptr); // Prototyp funkcji

   // Pętla kontrolująca iteracje tablicy
   for (unsigned int pass = 1; pass < size; ++pass) {

      // Pętla kontrolująca porównania w każdej iteracji tablicy
      for (size_t count = 0; count < size - 1; ++count) {

         // Zamiana miejscami sąsiadujących elementów, jeśli nie są ułożone w żądanej kolejności
         if ((*compare)(work[count], work[count + 1])) {
            swap(&work[count], &work[count + 1]);
         } 
      } 
   } 
} 

// Zamiana miejscami wartości w pamięci, w położeniach
// wskazywanych przez element1Ptr i element2Ptr
void swap(int *element1Ptr, int *element2Ptr)
{
   int hold = *element1Ptr;
   *element1Ptr = *element2Ptr;
   *element2Ptr = hold;
} 

// Ustalenie, które elementy nie są we właściwej kolejności
// dla sortowania w kolejności rosnącej
int ascending(int a, int b)
{
   return b < a; // Zamiana jeśli wartość b jest mniejsza niż a
}

// Ustalenie, które elementy nie są we właściwej kolejności
// dla sortowania w kolejności malejącej
int descending(int a, int b)
{
    return b > a; // Zamiana, jeśli wartość b jest większa niż a
}
