// Plik: fig22_04.cpp
// Przykład rozwinięcia stosu
#include <iostream>
#include <stdexcept>     
using namespace std;

// Funkcja function3() zgłasza błąd w trakcie działania programu
void function3()
{
   cout << "W funkcji function3()" << endl;

   // Brak bloku try, następuje rozwinięcie stosu, a kontrola nad przebiegiem programu powraca do funkcji function2()
   throw runtime_error( "Błąd w funkcji function3()" );    
} // Koniec funkcji function3()

// Funkcja function2() wywołuje function3().
void function2() 
{
   cout << "Funkcja function3() została wywołana w funkcji function2()." << endl;
   function3(); // Następuje rozwinięcie stosu, a kontrola nad przebiegiem programu powraca do funkcji function1()
} // Koniec funkcji function2()

// Funkcja function1() wywołuje funkcję function2()
void function1() 
{
   cout << "Funkcja function2() została wywołana w funkcji function1()." << endl;
   function2(); // Następuje rozwinięcie stosu, a kontrola nad przebiegiem programu powraca do funkcji main()
} // Koniec funkcji function1()

// Przykład pokazujący rozwinięcie stosu
int main()
{
   // Wywołanie funkcji function1()
   try 
   {
      cout << "Funkcja function1() została wywołana w funkcji main()." << endl;
      function1(); // Wywołanie funkcji function1() zgłaszającej błąd w trakcie działania programu
   } // Koniec bloku try
   catch ( runtime_error &error ) // Obsługa błędu w trakcie działania programu
   {
      cout << "Został zgłoszony wyjątek: " << error.what() << endl;
      cout << "Wyjątek został obsłużony przez funkcję main()." << endl;
   } // Koniec bloku catch
} // Koniec funkcji main()
