// Plik: CommissionEmployee.cpp
// Definicje funkcji składowych klasy CommissionEmployee
#include <iostream>
#include <stdexcept>
#include "CommissionEmployee.h" // Definicja klasy CommissionEmployee
using namespace std;

// Konstruktor
CommissionEmployee::CommissionEmployee( const string &first, 
   const string &last, const string &ssn, double sales, double rate )
   : Employee( first, last, ssn)   
{
   setGrossSales( sales );
   setCommissionRate( rate );
} // Koniec konstruktora klasy CommissionEmployee

// Zdefiniowanie wielkości sprzedaży
void CommissionEmployee::setGrossSales( double sales )
{
   if ( sales >= 0.0 )
      grossSales = sales;
   else
      throw invalid_argument( "Wielkość sprzedaży musi być wartością >= 0.0" );
} // Koniec funkcji setGrossSales()

// Pobranie wielkości sprzedaży
double CommissionEmployee::getGrossSales() const
{
   return grossSales;
} // Koniec funkcji getGrossSales()

// Zdefiniowanie procentowej wysokości prowizji
void CommissionEmployee::setCommissionRate( double rate )
{
   if ( rate > 0.0 && rate < 1.0 )
      commissionRate = rate;
   else
      throw invalid_argument( "Wysokość prowizji musi być wartością > 0.0 i < 1.0" );
} // Koniec funkcji setCommissionRate()

// Pobranie procentowej wysokości prowizji
double CommissionEmployee::getCommissionRate() const
{
   return commissionRate;
} // Koniec funkcji getCommissionRate()

// Obliczenie wynagrodzenia, nadpisanie czystej funkcji wirtualnej earnings() klasy Employee
double CommissionEmployee::earnings() const
{ 
   return getCommissionRate() * getGrossSales(); 
} // Koniec funkcji earnings()

// Wyświetlenie informacji przechowywanych w obiekcie CommissionEmployee
void CommissionEmployee::print() const
{
   cout << "Pracownik wynagradzany prowizyjnie: ";
   Employee::print(); // Ponowne użycie kodu
   cout << "\nWielkość sprzedaży: " << getGrossSales() 
      << "; Wysokość prowizji: " << getCommissionRate();
} // Koniec funkcji print()
