// Plik: fig17_22.cpp 
// Funkcja zaprzyjaźniona może uzyskać dostęp do prywatnych elementów składowych klasy
#include <iostream>
using namespace std;

// Definicja klasy Count
class Count 
{
   friend void setX( Count &, int ); // Deklaracja funkcji zaprzyjaźnionej
public:
   // Konstruktor
   Count() 
      : x( 0 ) // Inicjalizacja x z wartością 0
   { 
      // Pusta definicja funkcji
   } // Koniec konstruktora klasy Count

   // Wyświetlenie wartości zmiennej x
   void print() const       
   { 
      cout << x << endl; 
   } // Koniec funkcji print()
private:
   int x; // Dane składowe
}; // Koniec klasy Count

// Funkcja setX() może modyfikować prywatne dane składowe klasy Count, ponieważ
// setX() została zadeklarowana jako funkcja zaprzyjaźniona klasy Count (wiersz 9.)
void setX( Count &c, int val )
{
   c.x = val; // To jest dozwolone, ponieważ setX() została zadeklarowana jako funkcja zaprzyjaźniona klasy Count.
} // Koniec funkcji setX()

int main()
{
   Count counter; // Utworzenie obiektu klasy Count

   cout << "Wartość counter.x po utworzeniu obiektu: ";
   counter.print();  

   setX( counter, 8 ); // Przypisanie wartości x za pomocą funkcji zaprzyjaźnionej
   cout << "Wartość counter.x po wywołaniu funkcji zaprzyjaźnionej: ";
   counter.print();
} // Koniec funkcji main()
