// Plik: fig07_28.c
// Przykład użycia tablicy wskaźników do funkcji
#include <stdio.h>

// Prototypy funkcji
void function1(int a);
void function2(int b);
void function3(int c);

int main(void)
{
   // Inicjalizacja tablicy trzech wskaźników do funkcji, z których każda
   // pobiera argument w postaci liczby całkowitej i nie zwraca żadnej wartości
   void (*f[3])(int) = { function1, function2, function3 };  

   printf("%s", "Podaj liczbę z przedziału od 0 do 2, liczba 3 oznacza koniec: ");
   size_t choice; // Zmienna przechowująca liczbę podaną przez użytkownika
   scanf("%u", &choice);

   // Przetworzenie liczby podanej przez użytkownika
   while (choice >= 0 && choice < 3) {

      // Wywołanie funkcji znajdującej się w tablicy f, w elemencie o indeksie choice,
      // i przekazanie jej argumentu w postaci wartości choice
      (*f[choice])(choice);

      printf("%s", "Podaj liczbę z przedziału od 0 do 2, liczba 3 oznacza koniec: ");
      scanf("%u", &choice);
   } 

   puts("Wykonywanie programu zostało zakończone.");
} 

void function1(int a)
{
   printf("Wybrałeś opcję %d, więc została wywołana funkcja function1().\n\n", a);
} 

void function2(int b)
{
   printf("Wybrałeś opcję %d, więc została wywołana funkcja function2().\n\n", b);
} 

void function3(int c)
{
   printf("Wybrałeś opcję %d, więc została wywołana funkcja function3().\n\n", c);  
}
