// Plik: Employee.h
// Abstrakcyjna klasa bazowa Employee
#ifndef EMPLOYEE_H
#define EMPLOYEE_H

#include <string> // Standardowa klasa string w C++

class Employee 
{
public:
   Employee( const std::string &, const std::string &, 
      const std::string & );
   virtual ~Employee() { } // Destruktor wirtualny

   void setFirstName( const std::string & ); // Zdefiniowanie imienia
   std::string getFirstName() const; // Pobranie imienia

   void setLastName( const std::string & ); // Zdefiniowanie nazwiska
   std::string getLastName() const; // Pobranie nazwiska

   void setSocialSecurityNumber( const std::string & ); // Zdefiniowanie numeru ubezpieczenia społecznego
   std::string getSocialSecurityNumber() const; // Pobranie numeru ubezpieczenia społecznego

   // Czysta funkcja wirtualna powoduje, że Employee to abstrakcyjna klasa bazowa
   virtual double earnings() const = 0; // Czysta funkcja wirtualna
   virtual void print() const; // Funkcja wirtualna
private:
   std::string firstName;
   std::string lastName;
   std::string socialSecurityNumber;
}; // Koniec klasy Employee

#endif // EMPLOYEE_H
