// Plik: fig20_06.cpp
// Wprowadzenie do polimorfizmu, funkcji wirtualnych i wiązania dynamicznego
#include <iostream>
#include <iomanip>
#include "CommissionEmployee.h"
#include "BasePlusCommissionEmployee.h" 
using namespace std;

int main()
{
   // Utworzenie obiektu klasy bazowej
   CommissionEmployee commissionEmployee( 
      "Sara", "Janowska", "222-22-2222", 10000, .06 );

   // Utworzenie wskaźnika klasy bazowej
   CommissionEmployee *commissionEmployeePtr = nullptr;

   // Utworzenie obiektu klasy pochodnej
   BasePlusCommissionEmployee basePlusCommissionEmployee(
      "Bartek", "Lewicki", "333-33-3333", 5000, .04, 300 );

   // Utworzenie wskaźnika klasy pochodnej
   BasePlusCommissionEmployee *basePlusCommissionEmployeePtr = nullptr;

   // Formatowanie liczb zmiennoprzecinkowych w danych wyjściowych
   cout << fixed << setprecision( 2 );

   // Wyświetlenie zawartości obiektów za pomocą wiązania statycznego
   cout << "Wywołanie funkcji print() w obiektach klas bazowej i pochodnej "
      << "\nza pomocą wiązania statycznego\n\n";
   commissionEmployee.print(); // Wiązanie statyczne
   cout << "\n\n";
   basePlusCommissionEmployee.print(); // Wiązanie statyczne
   
   // Wyświetlenie zawartości obiektów za pomocą wiązania dynamicznego
   cout << "\n\n\nWywołanie funkcji print() w obiektach klas bazowej i pochodnej "
      << "\nza pomocą wiązania dynamicznego";

   // Skierowanie wskaźnika klasy bazowej na obiekt klasy bazowej i jego wyświetlenie
   commissionEmployeePtr = &commissionEmployee;
   cout << "\n\nWywołanie wirtualnej funkcji print() za pomocą wskaźnika klasy bazowej"
      << "\nprowadzącego do obiektu klasy bazowej powoduje wykonanie "
      << "funkcji print() klasy bazowej:\n\n";
   commissionEmployeePtr->print(); // Wywołanie funkcji print() klasy bazowej

   // Skierowanie wskaźnika klasy pochodnej na obiekt klasy pochodnej i jego wyświetlenie
   basePlusCommissionEmployeePtr = &basePlusCommissionEmployee;
   cout << "\n\nWywołanie wirtualnej funkcji print() za pomocą wskaźnika klasy pochodnej "
      << "\ndo obiektu klasy pochodnej powoduje wykonanie "
      << "funkcji print() klasy pochodnej:\n\n";
   basePlusCommissionEmployeePtr->print(); // Wywołanie funkcji print() klasy pochodnej

   // Skierowanie wskaźnika klasy bazowej na obiekt klasy pochodnej i jego wyświetlenie.
   commissionEmployeePtr = &basePlusCommissionEmployee;
   cout << "\n\nWywołanie wirtualnej funkcji print() za pomocą wskaźnika klasy bazowej"
      << "\ndo obiektu klasy pochodnej powoduje wykonanie "
      << "funkcji print() klasy pochodnej:\n\n";

   // Polimorfizm: wywołanie funkcji print() klasy BasePlusCommissionEmployee
   // Wskaźnik klasy bazowej prowadzi do obiektu klasy pochodnej
   commissionEmployeePtr->print();   
   cout << endl;
} // Koniec funkcji main()
