// Plik: BasePlusCommissionEmployee.h
// Klasa BasePlusCommissionEmployee jest
// klasą pochodną CommissionEmployee
#ifndef BASEPLUS_H
#define BASEPLUS_H

#include <string> // Standardowa klasa string w C++
#include "CommissionEmployee.h" // Deklaracja klasy CommissionEmployee

class BasePlusCommissionEmployee : public CommissionEmployee
{
public:
   BasePlusCommissionEmployee( const std::string &, const std::string &, 
      const std::string &, double = 0.0, double = 0.0, double = 0.0 );
   
   void setBaseSalary( double ); // Zdefiniowanie wynagrodzenia zasadniczego
   double getBaseSalary() const; // Pobranie wynagrodzenia zasadniczego

   virtual double earnings() const override; // Obliczenie wynagrodzenia
   virtual void print() const override; // Wyświetlenie zawartości obiektu
private:
   double baseSalary; // Wynagrodzenie zasadnicze
}; // Koniec klasy BasePlusCommissionEmployee

#endif
