// Plik: Hugeint.cpp 
// Definicje funkcji składowych i zaprzyjaźnionych klasy HugeInt
#include <cctype> // Prototyp funkcji isdigit()
#include "Hugeint.h" // Definicja klasy HugeInt
using namespace std;

// Konstruktor domyślny, konstruktor konwersji przeprowadzający
// konwersję dużej liczby całkowitej na postać obiektu typu HugeInt
HugeInt::HugeInt( long value )
{
   // Inicjalizacja tablicy z wartościami zero
   for ( short &element : integer )
      element = 0;   

   // Umieszczenie w tablicy cyfr argumentu
   for ( size_t j = digits - 1; value != 0 && j >= 0; j-- )
   {
      integer[ j ] = value % 10;
      value /= 10;
   } // Koniec konstrukcji for
} // Koniec konstruktora domyślnego i konwersji klasy HugeInt

// Konstruktor konwersji przeprowadzający konwersję ciągu tekstowego 
// przedstawiającego dużą liczbę całkowitą na postać obiektu typu HugeInt
HugeInt::HugeInt( const string &number )
{
   // Inicjalizacja tablicy z wartościami zero
   for ( short &element : integer )
      element = 0;   

   // Umieszczenie w tablicy cyfr argumentu
   size_t length = number.size();

   for ( size_t j = digits - length, k = 0; j < digits; ++j, ++k )
      if ( isdigit( number[ k ] ) ) // Sprawdzenie, czy to na pewno jest cyfra
         integer[ j ] = number[ k ] - '0';
} // Koniec konstruktora konwersji HugeInt

// Operator dodawania — HugeInt + HugeInt
HugeInt HugeInt::operator+( const HugeInt &op2 ) const
{
   HugeInt temp; // Wynik tymczasowy
   int carry = 0;

   for ( int i = digits - 1; i >= 0; i-- )
   {
      temp.integer[ i ] = integer[ i ] + op2.integer[ i ] + carry;

      // Ustalenie, czy przeprowadzić redukcję
      if ( temp.integer[ i ] > 9 )
      {
         temp.integer[ i ] %= 10;  // Redukcja do wartości 0 – 9
         carry = 1;
      } // Koniec konstrukcji if
      else // Brak redukcji
         carry = 0;
   } // Koniec konstrukcji for

   return temp; // Zwrot kopii obiektu tymczasowego
} // Koniec funkcji operator+()

// Operator dodawania — HugeInt + int
HugeInt HugeInt::operator+( int op2 ) const
{ 
   // Konwersja op2 na obiekt typu HugeInt, a następnie wywołanie 
   // funkcji operator+() dla dwóch obiektów typu HugeInt
   return *this + HugeInt( op2 ); 
} // Koniec funkcji operator+()

// Operator dodawania
// HugeInt + ciąg tekstowy przedstawiający ogromną wartość w postaci liczby całkowitej
HugeInt HugeInt::operator+( const string &op2 ) const
{ 
   // Konwersja op2 na obiekt typu HugeInt, a następnie wywołanie
   // funkcji operator+() dla dwóch obiektów typu HugeInt
   return *this + HugeInt( op2 ); 
} // Koniec funkcji operator+()

// Przeciążony operator <<
ostream& operator<<( ostream &output, const HugeInt &num )
{
   int i;

   for ( i = 0; ( i < HugeInt::digits ) && ( 0 == num.integer[ i ] ); ++i )
      ; // Pominięcie zer na początku

   if ( i == HugeInt::digits )
      output << 0;
   else
      for ( ; i < HugeInt::digits; ++i )
         output << num.integer[ i ];

   return output;
} // Koniec funkcji operator<<()
