// Plik: Date.cpp
// Definicje funkcji składowych klasy
#include <array>
#include <iostream>
#include <stdexcept>
#include "Date.h" // Dołączenie definicji klasy Date
using namespace std;

// Konstruktor sprawdza poprawność wartości dla miesiąca, wywołuje funkcję
// narzędziową checkDay(), aby sprawdzić poprawność wartości dla dnia
Date::Date( int dy, int mn, int yr )
{
   if ( mn > 0 && mn <= monthsPerYear ) // Sprawdzenie poprawności wartości dla miesiąca
      month = mn;
   else 
      throw invalid_argument( "To musi być wartość z przedziału 1-12." );

   year = yr; // Można sprawdzić także rok
   day = checkDay( dy ); // Sprawdzenie poprawności wartości dla dnia

   // Wyświetlenie obiektu Date, aby pokazać, kiedy nastąpiło wywołanie konstruktora
   cout << "Konstruktor obiektu Date reprezentującego datę ";
   print();                   
   cout << endl;
} // Koniec konstruktora klasy Date

// Wyświetlenie obiektu Date w formacie dzień/miesiąc/rok
void Date::print() const
{
   cout << day << '/' << month << '/' << year; 
} // Koniec funkcji print()

// Wyświetlenie obiektu Date, aby pokazać, kiedy nastąpiło wywołanie destruktora
Date::~Date()
{ 
   cout << "Destruktor obiektu Date reprezentującego datę ";
   print();
   cout << endl;
} // Koniec destruktora ~Date()

// Funkcja narzędziowa potwierdzająca prawidłową wartość dnia
// na podstawie miesiąca i roku, obsługuje również lata przestępne
unsigned int Date::checkDay( int testDay ) const
{
   static const array< int, monthsPerYear + 1 > daysPerMonth = 
      { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

   // Ustalenie, czy wartość testDay jest poprawna dla danego miesiąca
   if ( testDay > 0 && testDay <= daysPerMonth[ month ] )
      return testDay;

   // 29 lutego — sprawdzenie pod kątem roku przestępnego
   if ( month == 2 && testDay == 29 && ( year % 400 == 0 || 
      ( year % 4 == 0 && year % 100 != 0 ) ) )
      return testDay;

   throw invalid_argument( "Nieprawidłowa wartość dla miesiąca i dnia" );
} // Koniec funkcji checkDay()
