// Plik: fig12_08.c
// Prosty program implementujący stos
#include <stdio.h>
#include <stdlib.h>

// Struktura odwołująca się do samej siebie
struct stackNode {  
   int data; // Zdefiniowanie zmiennej data jako typu int
   struct stackNode *nextPtr; // Wskaźnik stackNode
};

typedef struct stackNode StackNode; // Synonim dla struktury stackNode
typedef StackNode *StackNodePtr; // Synonim dla StackNode*

// Prototypy funkcji
void push(StackNodePtr *topPtr, int info);
int pop(StackNodePtr *topPtr);
int isEmpty(StackNodePtr topPtr);
void printStack(StackNodePtr currentPtr);
void instructions(void);

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{ 
   StackNodePtr stackPtr = NULL; // Wskaźnik prowadzący na wierzch stosu
   int value; // Wartość typu int podana przez użytkownika
 
   instructions(); // Wyświetlenie menu
   printf("%s", "? ");
   unsigned int choice; // Opcja wybrana przez użytkownika
   scanf("%u", &choice);

   // Pętla będzie wykonywana dopóty, dopóki użytkownik nie wybierze opcji 3
   while (choice != 3) { 

      switch (choice) { 
         // Umieszczenie wartości na stosie
         case 1:      
            printf("%s", "Podaj liczbę całkowitą: ");
            scanf("%d", &value);
            push(&stackPtr, value);
            printStack(stackPtr);
            break;
         // Usunięcie wartości ze stosu
         case 2:      
            // Jeżeli stos nie jest pusty
            if (!isEmpty(stackPtr)) {
               printf("Ze stosu została usunięta wartość %d.\n", pop(&stackPtr));
            } 

            printStack(stackPtr);
            break;
         default:
            puts("Nieprawidłowa opcja.\n");
            instructions();
            break;
      } 

      printf("%s", "? ");
      scanf("%u", &choice);
   } 

   puts("Program zakończył działanie.");
} 

// Wyświetlenie użytkownikowi informacji o sposobie działania programu
void instructions(void)
{ 
   puts("Wybierz jedną z dostępnych opcji:\n"
      "1 - umieszczenie wartości na stosie\n"
      "2 - usunięcie wartości ze stosu\n"
      "3 - zakończenie programu");
} 

// Umieszczenie węzła na wierzchu stosu
void push(StackNodePtr *topPtr, int info)
{ 
   StackNodePtr newPtr = malloc(sizeof(StackNode)); 

   // Wstawienie węzła na wierzchu stosu
   if (newPtr != NULL) {
      newPtr->data = info;
      newPtr->nextPtr = *topPtr;
      *topPtr = newPtr;
   }
   else { // Brak wolnej pamięci
      printf("Nie udało się wstawić %d z powodu braku wolnej pamięci.\n", info);
   } 
} 

// Usunięcie węzła z wierzchu stosu
int pop(StackNodePtr *topPtr)
{ 
   StackNodePtr tempPtr = *topPtr;
   int popValue = (*topPtr)->data;
   *topPtr = (*topPtr)->nextPtr;
   free(tempPtr);
   return popValue;
} 

// Wyświetlenie zawartości stosu
void printStack(StackNodePtr currentPtr)
{
   // Jeżeli stos jest pusty
   if (currentPtr == NULL) {
      puts("Stos jest pusty.\n");
   } 
   else { 
      puts("Oto zawartość stosu:");

      // Pętla będzie wykonywana aż do końca stosu
      while (currentPtr != NULL) { 
         printf("%d --> ", currentPtr->data);
         currentPtr = currentPtr->nextPtr;
      } 

      puts("NULL\n");
   } 
} 

// Wartością zwrotną jest 1, jeżeli stos jest pusty, w przeciwnym przypadku funkcja zwraca 0
int isEmpty(StackNodePtr topPtr)
{ 
   return topPtr == NULL;
}
