// Plik: fig11_06.c
// Odczytanie i wyświetlenie zawartości pliku o dostępie sekwencyjnym
#include <stdio.h>

int main(void)
{ 
   FILE *cfPtr; // cfPtr = wskaźnik pliku client.txt

   // Funkcja fopen() otwiera plik. Jeżeli plik nie może zostać otworzony, nastąpi zakończenie działania programu
   if ((cfPtr = fopen("clients.txt", "r")) == NULL) {
      puts("Nie udało się otworzyć pliku.");
   } 
   else { // Odczytanie następujących danych z pliku: numer konta, nazwisko klienta i saldo konta klienta
      unsigned int account; // Numer konta   
      char name[30]; // Nazwisko klienta
      double balance; // Saldo konta klienta   

      printf("%-10s%-15s%s\n", "Konto", "Nazwisko", "Saldo");
      fscanf(cfPtr, "%d%29s%lf", &account, name, &balance);

      // Dopóki nie zostanie napotkany znak końca pliku
      while (!feof(cfPtr)) { 
         printf("%-10d%-13s%7.2f\n", account, name, balance);
         fscanf(cfPtr, "%d%29s%lf", &account, name, &balance);
      } 

      fclose(cfPtr); // Funkcja fclose() zamyka plik
   } 
}
