// Plik: figD_03.c
// Algorytm sortowania przez scalanie 
#define SIZE 10
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Prototypy funkcji
void mergeSort(int array[], size_t length);
void sortSubArray(int array[], size_t low, size_t high);
void merge(int array[], size_t left, size_t middle1, 
   size_t middle2, size_t right);
void displayElements(int array[], size_t length);
void displaySubArray(int array[], size_t left, size_t right);

int main(void)
{
   int array[SIZE]; // Deklaracja tablicy zawierającej wartości typu int do posortowania
    
   srand(time(NULL)); // Wartość zalążka dla funkcji sortowania 
    
   for (size_t i = 0; i < SIZE; i++) {
      array[i] = rand() % 90 + 10; // Zdefiniowanie wartości dla każdego elementu 
   }
        
   puts("Tablica nieposortowana:");
   displayElements(array, SIZE); // Wyświetlenie zawartości tablicy 
   puts("\n");
   mergeSort(array, SIZE); // Sortowanie tablicy przez scalanie 
   puts("Tablica posortowana:");
   displayElements(array, SIZE); // Wyświetlenie zawartości tablicy 
} 

// Funkcja używająca algorytmu sortowania przez scalanie
void mergeSort(int array[], size_t length)
{
   sortSubArray(array, 0, length - 1);
} 

// Funkcja sortująca tylko fragment tablicy 
void sortSubArray(int array[], size_t low, size_t high)
{
   // Przypadek bazowy: wielkość tablicy wynosi 1
   if ((high - low) >= 1) { // Jeżeli to nie jest przypadek bazowy… 
      size_t middle1 = (low + high) / 2;
      size_t middle2 = middle1 + 1;
        
      // Wyświetlenie kroku podziału 
      printf("%s", "podział:   ");
      displaySubArray(array, low, high);
      printf("%s", "\n         ");
      displaySubArray(array, low, middle1);
      printf("%s", "\n         ");
      displaySubArray(array, middle2, high);
      puts("\n");
        
      // Podzielenie tablicy na pół i rekurencyjne sortowanie obu podtablic 
      sortSubArray(array, low, middle1); // Pierwsza połowa tablicy
      sortSubArray(array, middle2, high); // Druga połowa tablicy
        
      // Połączenie dwóch posortowanych tablic 
      merge(array, low, middle1, middle2, high);
   } 
}

// Połączenie dwóch posortowanych tablic w jedną większą
void merge(int array[], size_t left, size_t middle1, 
   size_t middle2, size_t right)
{
   size_t leftIndex = left; // Indeks do lewej podtablicy 
   size_t rightIndex = middle2; // Indeks do prawej podtablicy
   size_t combinedIndex = left; // Indeks do tablicy tymczasowej 
   int tempArray[SIZE]; // Tablica tymczasowa 
    
   // Wyświetlenie dwóch podtablic przed ich połączeniem 
   printf("%s", "łączenie:   ");
   displaySubArray(array, left, middle1);
   printf("%s", "\n         ");
   displaySubArray(array, middle2, right);
   puts("");
    
   // Operacja łączenia podtablic trwa dopóty, dopóki nie zostanie osiągnięty koniec jednej z nich 
   while (leftIndex <= middle1 && rightIndex <= right) {
      // Umieszczenie w wyniku mniejszego z dwóch bieżących elementów 
      // i przejście do następnego położenia w podtablicy 
      if (array[leftIndex] <= array[rightIndex]) {
         tempArray[combinedIndex++] = array[leftIndex++];
      } 
      else {
         tempArray[combinedIndex++] = array[rightIndex++];
      } 
   }
    
   if (leftIndex == middle2) { // Jeżeli to jest koniec lewej podtablicy… 
      while (rightIndex <= right) { // Skopiowanie prawej podtablicy 
         tempArray[combinedIndex++] = array[rightIndex++];
      } 
   } 
   else { // Jeżeli to jest koniec prawej podtablicy… 
      while (leftIndex <= middle1) { // Skopiowanie lewej podtablicy
         tempArray[combinedIndex++] = array[leftIndex++];
      } 
   } 
    
   // Skopiowanie wartości z powrotem do tablicy pierwotnej 
   for (size_t i = left; i <= right; i++) {
      array[i] = tempArray[i];
   } 
    
   // Wyświetlenie połączonych podtablic 
   printf("%s", "         ");
   displaySubArray(array, left, right);
   puts("\n");
} 

// Wyświetlenie elementów w tablicy 
void displayElements(int array[], size_t length)
{
   displaySubArray(array, 0, length - 1);
} 

// Wyświetlenie określonych elementów w tablicy
void displaySubArray(int array[], size_t left, size_t right)
{
   // Wyświetlenie spacji na potrzeby wyrównania danych 
   for (size_t i = 0; i < left; i++) {
      printf("%s", "   ");
   } 
    
   // Wyświetlenie elementów pozostałych w tablicy 
   for (size_t i = left; i <= right; i++) {
      printf(" %d", array[i]);
   } 
}
